package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeFileSystemsResponse(
    fileSystems: Optional[Iterable[zio.aws.fsx.model.FileSystem]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse = {
    import DescribeFileSystemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse
      .builder()
      .optionallyWith(
        fileSystems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileSystems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeFileSystemsResponse.ReadOnly =
    zio.aws.fsx.model.DescribeFileSystemsResponse.wrap(buildAwsValue())
}
object DescribeFileSystemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeFileSystemsResponse =
      zio.aws.fsx.model.DescribeFileSystemsResponse(
        fileSystems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fileSystems: Optional[List[zio.aws.fsx.model.FileSystem.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getFileSystems
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.FileSystem.ReadOnly]] =
      AwsError.unwrapOptionField("fileSystems", fileSystems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse
  ) extends zio.aws.fsx.model.DescribeFileSystemsResponse.ReadOnly {
    override val fileSystems
        : Optional[List[zio.aws.fsx.model.FileSystem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.FileSystem.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileSystemsResponse
  ): zio.aws.fsx.model.DescribeFileSystemsResponse.ReadOnly = new Wrapper(impl)
}
