package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{NextToken, MaxResults, VolumeId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeVolumesRequest(
    volumeIds: Optional[Iterable[VolumeId]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.fsx.model.VolumeFilter]] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeVolumesRequest = {
    import DescribeVolumesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeVolumesRequest
      .builder()
      .optionallyWith(
        volumeIds.map(value =>
          value.map { item =>
            VolumeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.volumeIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeVolumesRequest.ReadOnly =
    zio.aws.fsx.model.DescribeVolumesRequest.wrap(buildAwsValue())
}
object DescribeVolumesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeVolumesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeVolumesRequest =
      zio.aws.fsx.model.DescribeVolumesRequest(
        volumeIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def volumeIds: Optional[List[VolumeId]]
    def filters: Optional[List[zio.aws.fsx.model.VolumeFilter.ReadOnly]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getVolumeIds: ZIO[Any, AwsError, List[VolumeId]] =
      AwsError.unwrapOptionField("volumeIds", volumeIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.VolumeFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeVolumesRequest
  ) extends zio.aws.fsx.model.DescribeVolumesRequest.ReadOnly {
    override val volumeIds: Optional[List[VolumeId]] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.VolumeId(item)
        }.toList
      )
    override val filters
        : Optional[List[zio.aws.fsx.model.VolumeFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.VolumeFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeVolumesRequest
  ): zio.aws.fsx.model.DescribeVolumesRequest.ReadOnly = new Wrapper(impl)
}
