package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait FileSystemMaintenanceOperation {
  def unwrap
      : software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation
}
object FileSystemMaintenanceOperation {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation
  ): zio.aws.fsx.model.FileSystemMaintenanceOperation = value match {
    case software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation.PATCHING =>
      val r = PATCHING
      r
    case software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation.BACKING_UP =>
      val r = BACKING_UP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.FileSystemMaintenanceOperation {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation =
      software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation.UNKNOWN_TO_SDK_VERSION
  }
  case object PATCHING
      extends zio.aws.fsx.model.FileSystemMaintenanceOperation {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation =
      software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation.PATCHING
  }
  case object BACKING_UP
      extends zio.aws.fsx.model.FileSystemMaintenanceOperation {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation =
      software.amazon.awssdk.services.fsx.model.FileSystemMaintenanceOperation.BACKING_UP
  }
}
