package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait FilterName {
  def unwrap: software.amazon.awssdk.services.fsx.model.FilterName
}
object FilterName {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.FilterName
  ): zio.aws.fsx.model.FilterName = value match {
    case software.amazon.awssdk.services.fsx.model.FilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.FilterName.FILE_SYSTEM_ID =>
      val r = `file-system-id`
      r
    case software.amazon.awssdk.services.fsx.model.FilterName.BACKUP_TYPE =>
      val r = `backup-type`
      r
    case software.amazon.awssdk.services.fsx.model.FilterName.FILE_SYSTEM_TYPE =>
      val r = `file-system-type`
      r
    case software.amazon.awssdk.services.fsx.model.FilterName.VOLUME_ID =>
      val r = `volume-id`
      r
    case software.amazon.awssdk.services.fsx.model.FilterName.DATA_REPOSITORY_TYPE =>
      val r = `data-repository-type`
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.FilterName {
    override def unwrap: software.amazon.awssdk.services.fsx.model.FilterName =
      software.amazon.awssdk.services.fsx.model.FilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object `file-system-id` extends zio.aws.fsx.model.FilterName {
    override def unwrap: software.amazon.awssdk.services.fsx.model.FilterName =
      software.amazon.awssdk.services.fsx.model.FilterName.FILE_SYSTEM_ID
  }
  case object `backup-type` extends zio.aws.fsx.model.FilterName {
    override def unwrap: software.amazon.awssdk.services.fsx.model.FilterName =
      software.amazon.awssdk.services.fsx.model.FilterName.BACKUP_TYPE
  }
  case object `file-system-type` extends zio.aws.fsx.model.FilterName {
    override def unwrap: software.amazon.awssdk.services.fsx.model.FilterName =
      software.amazon.awssdk.services.fsx.model.FilterName.FILE_SYSTEM_TYPE
  }
  case object `volume-id` extends zio.aws.fsx.model.FilterName {
    override def unwrap: software.amazon.awssdk.services.fsx.model.FilterName =
      software.amazon.awssdk.services.fsx.model.FilterName.VOLUME_ID
  }
  case object `data-repository-type` extends zio.aws.fsx.model.FilterName {
    override def unwrap: software.amazon.awssdk.services.fsx.model.FilterName =
      software.amazon.awssdk.services.fsx.model.FilterName.DATA_REPOSITORY_TYPE
  }
}
