package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait LustreDeploymentType {
  def unwrap: software.amazon.awssdk.services.fsx.model.LustreDeploymentType
}
object LustreDeploymentType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.LustreDeploymentType
  ): zio.aws.fsx.model.LustreDeploymentType = value match {
    case software.amazon.awssdk.services.fsx.model.LustreDeploymentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.LustreDeploymentType.SCRATCH_1 =>
      val r = SCRATCH_1
      r
    case software.amazon.awssdk.services.fsx.model.LustreDeploymentType.SCRATCH_2 =>
      val r = SCRATCH_2
      r
    case software.amazon.awssdk.services.fsx.model.LustreDeploymentType.PERSISTENT_1 =>
      val r = PERSISTENT_1
      r
    case software.amazon.awssdk.services.fsx.model.LustreDeploymentType.PERSISTENT_2 =>
      val r = PERSISTENT_2
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.LustreDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.LustreDeploymentType =
      software.amazon.awssdk.services.fsx.model.LustreDeploymentType.UNKNOWN_TO_SDK_VERSION
  }
  case object SCRATCH_1 extends zio.aws.fsx.model.LustreDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.LustreDeploymentType =
      software.amazon.awssdk.services.fsx.model.LustreDeploymentType.SCRATCH_1
  }
  case object SCRATCH_2 extends zio.aws.fsx.model.LustreDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.LustreDeploymentType =
      software.amazon.awssdk.services.fsx.model.LustreDeploymentType.SCRATCH_2
  }
  case object PERSISTENT_1 extends zio.aws.fsx.model.LustreDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.LustreDeploymentType =
      software.amazon.awssdk.services.fsx.model.LustreDeploymentType.PERSISTENT_1
  }
  case object PERSISTENT_2 extends zio.aws.fsx.model.LustreDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.LustreDeploymentType =
      software.amazon.awssdk.services.fsx.model.LustreDeploymentType.PERSISTENT_2
  }
}
