package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.GeneralARN
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LustreLogCreateConfiguration(
    level: zio.aws.fsx.model.LustreAccessAuditLogLevel,
    destination: Optional[GeneralARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.LustreLogCreateConfiguration = {
    import LustreLogCreateConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.LustreLogCreateConfiguration
      .builder()
      .level(level.unwrap)
      .optionallyWith(
        destination.map(value => GeneralARN.unwrap(value): java.lang.String)
      )(_.destination)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.LustreLogCreateConfiguration.ReadOnly =
    zio.aws.fsx.model.LustreLogCreateConfiguration.wrap(buildAwsValue())
}
object LustreLogCreateConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.LustreLogCreateConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.LustreLogCreateConfiguration =
      zio.aws.fsx.model
        .LustreLogCreateConfiguration(level, destination.map(value => value))
    def level: zio.aws.fsx.model.LustreAccessAuditLogLevel
    def destination: Optional[GeneralARN]
    def getLevel
        : ZIO[Any, Nothing, zio.aws.fsx.model.LustreAccessAuditLogLevel] =
      ZIO.succeed(level)
    def getDestination: ZIO[Any, AwsError, GeneralARN] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.LustreLogCreateConfiguration
  ) extends zio.aws.fsx.model.LustreLogCreateConfiguration.ReadOnly {
    override val level: zio.aws.fsx.model.LustreAccessAuditLogLevel =
      zio.aws.fsx.model.LustreAccessAuditLogLevel.wrap(impl.level())
    override val destination: Optional[GeneralARN] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.fsx.model.primitives.GeneralARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.LustreLogCreateConfiguration
  ): zio.aws.fsx.model.LustreLogCreateConfiguration.ReadOnly = new Wrapper(impl)
}
