package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait OntapDeploymentType {
  def unwrap: software.amazon.awssdk.services.fsx.model.OntapDeploymentType
}
object OntapDeploymentType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.OntapDeploymentType
  ): zio.aws.fsx.model.OntapDeploymentType = value match {
    case software.amazon.awssdk.services.fsx.model.OntapDeploymentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.OntapDeploymentType.MULTI_AZ_1 =>
      val r = MULTI_AZ_1
      r
    case software.amazon.awssdk.services.fsx.model.OntapDeploymentType.SINGLE_AZ_1 =>
      val r = SINGLE_AZ_1
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.OntapDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OntapDeploymentType =
      software.amazon.awssdk.services.fsx.model.OntapDeploymentType.UNKNOWN_TO_SDK_VERSION
  }
  case object MULTI_AZ_1 extends zio.aws.fsx.model.OntapDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OntapDeploymentType =
      software.amazon.awssdk.services.fsx.model.OntapDeploymentType.MULTI_AZ_1
  }
  case object SINGLE_AZ_1 extends zio.aws.fsx.model.OntapDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OntapDeploymentType =
      software.amazon.awssdk.services.fsx.model.OntapDeploymentType.SINGLE_AZ_1
  }
}
