package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  SubnetId,
  DailyTime,
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  RouteTableId,
  WeeklyTime,
  IpAddressRange
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class OntapFileSystemConfiguration(
    automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays] =
      Optional.Absent,
    dailyAutomaticBackupStartTime: Optional[DailyTime] = Optional.Absent,
    deploymentType: Optional[zio.aws.fsx.model.OntapDeploymentType] =
      Optional.Absent,
    endpointIpAddressRange: Optional[IpAddressRange] = Optional.Absent,
    endpoints: Optional[zio.aws.fsx.model.FileSystemEndpoints] =
      Optional.Absent,
    diskIopsConfiguration: Optional[zio.aws.fsx.model.DiskIopsConfiguration] =
      Optional.Absent,
    preferredSubnetId: Optional[SubnetId] = Optional.Absent,
    routeTableIds: Optional[Iterable[RouteTableId]] = Optional.Absent,
    throughputCapacity: Optional[MegabytesPerSecond] = Optional.Absent,
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.OntapFileSystemConfiguration = {
    import OntapFileSystemConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.OntapFileSystemConfiguration
      .builder()
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(deploymentType.map(value => value.unwrap))(
        _.deploymentType
      )
      .optionallyWith(
        endpointIpAddressRange.map(value =>
          IpAddressRange.unwrap(value): java.lang.String
        )
      )(_.endpointIpAddressRange)
      .optionallyWith(endpoints.map(value => value.buildAwsValue()))(
        _.endpoints
      )
      .optionallyWith(
        diskIopsConfiguration.map(value => value.buildAwsValue())
      )(_.diskIopsConfiguration)
      .optionallyWith(
        preferredSubnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.preferredSubnetId)
      .optionallyWith(
        routeTableIds.map(value =>
          value.map { item =>
            RouteTableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.routeTableIds)
      .optionallyWith(
        throughputCapacity.map(value =>
          MegabytesPerSecond.unwrap(value): Integer
        )
      )(_.throughputCapacity)
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.OntapFileSystemConfiguration.ReadOnly =
    zio.aws.fsx.model.OntapFileSystemConfiguration.wrap(buildAwsValue())
}
object OntapFileSystemConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.OntapFileSystemConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.OntapFileSystemConfiguration =
      zio.aws.fsx.model.OntapFileSystemConfiguration(
        automaticBackupRetentionDays.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        deploymentType.map(value => value),
        endpointIpAddressRange.map(value => value),
        endpoints.map(value => value.asEditable),
        diskIopsConfiguration.map(value => value.asEditable),
        preferredSubnetId.map(value => value),
        routeTableIds.map(value => value),
        throughputCapacity.map(value => value),
        weeklyMaintenanceStartTime.map(value => value)
      )
    def automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays]
    def dailyAutomaticBackupStartTime: Optional[DailyTime]
    def deploymentType: Optional[zio.aws.fsx.model.OntapDeploymentType]
    def endpointIpAddressRange: Optional[IpAddressRange]
    def endpoints: Optional[zio.aws.fsx.model.FileSystemEndpoints.ReadOnly]
    def diskIopsConfiguration
        : Optional[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly]
    def preferredSubnetId: Optional[SubnetId]
    def routeTableIds: Optional[List[RouteTableId]]
    def throughputCapacity: Optional[MegabytesPerSecond]
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getDeploymentType
        : ZIO[Any, AwsError, zio.aws.fsx.model.OntapDeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getEndpointIpAddressRange: ZIO[Any, AwsError, IpAddressRange] = AwsError
      .unwrapOptionField("endpointIpAddressRange", endpointIpAddressRange)
    def getEndpoints
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystemEndpoints.ReadOnly] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getDiskIopsConfiguration
        : ZIO[Any, AwsError, zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("diskIopsConfiguration", diskIopsConfiguration)
    def getPreferredSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("preferredSubnetId", preferredSubnetId)
    def getRouteTableIds: ZIO[Any, AwsError, List[RouteTableId]] =
      AwsError.unwrapOptionField("routeTableIds", routeTableIds)
    def getThroughputCapacity: ZIO[Any, AwsError, MegabytesPerSecond] =
      AwsError.unwrapOptionField("throughputCapacity", throughputCapacity)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.OntapFileSystemConfiguration
  ) extends zio.aws.fsx.model.OntapFileSystemConfiguration.ReadOnly {
    override val automaticBackupRetentionDays
        : Optional[AutomaticBackupRetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val dailyAutomaticBackupStartTime: Optional[DailyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dailyAutomaticBackupStartTime())
        .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val deploymentType
        : Optional[zio.aws.fsx.model.OntapDeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentType())
        .map(value => zio.aws.fsx.model.OntapDeploymentType.wrap(value))
    override val endpointIpAddressRange: Optional[IpAddressRange] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointIpAddressRange())
        .map(value => zio.aws.fsx.model.primitives.IpAddressRange(value))
    override val endpoints
        : Optional[zio.aws.fsx.model.FileSystemEndpoints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoints())
        .map(value => zio.aws.fsx.model.FileSystemEndpoints.wrap(value))
    override val diskIopsConfiguration
        : Optional[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskIopsConfiguration())
        .map(value => zio.aws.fsx.model.DiskIopsConfiguration.wrap(value))
    override val preferredSubnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredSubnetId())
      .map(value => zio.aws.fsx.model.primitives.SubnetId(value))
    override val routeTableIds: Optional[List[RouteTableId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeTableIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.RouteTableId(item)
          }.toList
        )
    override val throughputCapacity: Optional[MegabytesPerSecond] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputCapacity())
        .map(value => zio.aws.fsx.model.primitives.MegabytesPerSecond(value))
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.OntapFileSystemConfiguration
  ): zio.aws.fsx.model.OntapFileSystemConfiguration.ReadOnly = new Wrapper(impl)
}
