package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  JunctionPath,
  StorageVirtualMachineId,
  VolumeCapacity,
  Flag,
  UUID
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class OntapVolumeConfiguration(
    flexCacheEndpointType: Optional[zio.aws.fsx.model.FlexCacheEndpointType] =
      Optional.Absent,
    junctionPath: Optional[JunctionPath] = Optional.Absent,
    securityStyle: Optional[zio.aws.fsx.model.SecurityStyle] = Optional.Absent,
    sizeInMegabytes: Optional[VolumeCapacity] = Optional.Absent,
    storageEfficiencyEnabled: Optional[Flag] = Optional.Absent,
    storageVirtualMachineId: Optional[StorageVirtualMachineId] =
      Optional.Absent,
    storageVirtualMachineRoot: Optional[Flag] = Optional.Absent,
    tieringPolicy: Optional[zio.aws.fsx.model.TieringPolicy] = Optional.Absent,
    uuid: Optional[UUID] = Optional.Absent,
    ontapVolumeType: Optional[zio.aws.fsx.model.OntapVolumeType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.OntapVolumeConfiguration = {
    import OntapVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.OntapVolumeConfiguration
      .builder()
      .optionallyWith(flexCacheEndpointType.map(value => value.unwrap))(
        _.flexCacheEndpointType
      )
      .optionallyWith(
        junctionPath.map(value => JunctionPath.unwrap(value): java.lang.String)
      )(_.junctionPath)
      .optionallyWith(securityStyle.map(value => value.unwrap))(_.securityStyle)
      .optionallyWith(
        sizeInMegabytes.map(value => VolumeCapacity.unwrap(value): Integer)
      )(_.sizeInMegabytes)
      .optionallyWith(
        storageEfficiencyEnabled.map(value =>
          Flag.unwrap(value): java.lang.Boolean
        )
      )(_.storageEfficiencyEnabled)
      .optionallyWith(
        storageVirtualMachineId.map(value =>
          StorageVirtualMachineId.unwrap(value): java.lang.String
        )
      )(_.storageVirtualMachineId)
      .optionallyWith(
        storageVirtualMachineRoot.map(value =>
          Flag.unwrap(value): java.lang.Boolean
        )
      )(_.storageVirtualMachineRoot)
      .optionallyWith(tieringPolicy.map(value => value.buildAwsValue()))(
        _.tieringPolicy
      )
      .optionallyWith(uuid.map(value => UUID.unwrap(value): java.lang.String))(
        _.uuid
      )
      .optionallyWith(ontapVolumeType.map(value => value.unwrap))(
        _.ontapVolumeType
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.OntapVolumeConfiguration.ReadOnly =
    zio.aws.fsx.model.OntapVolumeConfiguration.wrap(buildAwsValue())
}
object OntapVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.OntapVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.OntapVolumeConfiguration =
      zio.aws.fsx.model.OntapVolumeConfiguration(
        flexCacheEndpointType.map(value => value),
        junctionPath.map(value => value),
        securityStyle.map(value => value),
        sizeInMegabytes.map(value => value),
        storageEfficiencyEnabled.map(value => value),
        storageVirtualMachineId.map(value => value),
        storageVirtualMachineRoot.map(value => value),
        tieringPolicy.map(value => value.asEditable),
        uuid.map(value => value),
        ontapVolumeType.map(value => value)
      )
    def flexCacheEndpointType: Optional[zio.aws.fsx.model.FlexCacheEndpointType]
    def junctionPath: Optional[JunctionPath]
    def securityStyle: Optional[zio.aws.fsx.model.SecurityStyle]
    def sizeInMegabytes: Optional[VolumeCapacity]
    def storageEfficiencyEnabled: Optional[Flag]
    def storageVirtualMachineId: Optional[StorageVirtualMachineId]
    def storageVirtualMachineRoot: Optional[Flag]
    def tieringPolicy: Optional[zio.aws.fsx.model.TieringPolicy.ReadOnly]
    def uuid: Optional[UUID]
    def ontapVolumeType: Optional[zio.aws.fsx.model.OntapVolumeType]
    def getFlexCacheEndpointType
        : ZIO[Any, AwsError, zio.aws.fsx.model.FlexCacheEndpointType] =
      AwsError.unwrapOptionField("flexCacheEndpointType", flexCacheEndpointType)
    def getJunctionPath: ZIO[Any, AwsError, JunctionPath] =
      AwsError.unwrapOptionField("junctionPath", junctionPath)
    def getSecurityStyle: ZIO[Any, AwsError, zio.aws.fsx.model.SecurityStyle] =
      AwsError.unwrapOptionField("securityStyle", securityStyle)
    def getSizeInMegabytes: ZIO[Any, AwsError, VolumeCapacity] =
      AwsError.unwrapOptionField("sizeInMegabytes", sizeInMegabytes)
    def getStorageEfficiencyEnabled: ZIO[Any, AwsError, Flag] = AwsError
      .unwrapOptionField("storageEfficiencyEnabled", storageEfficiencyEnabled)
    def getStorageVirtualMachineId
        : ZIO[Any, AwsError, StorageVirtualMachineId] = AwsError
      .unwrapOptionField("storageVirtualMachineId", storageVirtualMachineId)
    def getStorageVirtualMachineRoot: ZIO[Any, AwsError, Flag] = AwsError
      .unwrapOptionField("storageVirtualMachineRoot", storageVirtualMachineRoot)
    def getTieringPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.TieringPolicy.ReadOnly] =
      AwsError.unwrapOptionField("tieringPolicy", tieringPolicy)
    def getUuid: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("uuid", uuid)
    def getOntapVolumeType
        : ZIO[Any, AwsError, zio.aws.fsx.model.OntapVolumeType] =
      AwsError.unwrapOptionField("ontapVolumeType", ontapVolumeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.OntapVolumeConfiguration
  ) extends zio.aws.fsx.model.OntapVolumeConfiguration.ReadOnly {
    override val flexCacheEndpointType
        : Optional[zio.aws.fsx.model.FlexCacheEndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flexCacheEndpointType())
        .map(value => zio.aws.fsx.model.FlexCacheEndpointType.wrap(value))
    override val junctionPath: Optional[JunctionPath] = zio.aws.core.internal
      .optionalFromNullable(impl.junctionPath())
      .map(value => zio.aws.fsx.model.primitives.JunctionPath(value))
    override val securityStyle: Optional[zio.aws.fsx.model.SecurityStyle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityStyle())
        .map(value => zio.aws.fsx.model.SecurityStyle.wrap(value))
    override val sizeInMegabytes: Optional[VolumeCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeInMegabytes())
        .map(value => zio.aws.fsx.model.primitives.VolumeCapacity(value))
    override val storageEfficiencyEnabled: Optional[Flag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageEfficiencyEnabled())
        .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val storageVirtualMachineId: Optional[StorageVirtualMachineId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageVirtualMachineId())
        .map(value =>
          zio.aws.fsx.model.primitives.StorageVirtualMachineId(value)
        )
    override val storageVirtualMachineRoot: Optional[Flag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageVirtualMachineRoot())
        .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val tieringPolicy
        : Optional[zio.aws.fsx.model.TieringPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tieringPolicy())
        .map(value => zio.aws.fsx.model.TieringPolicy.wrap(value))
    override val uuid: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.uuid())
      .map(value => zio.aws.fsx.model.primitives.UUID(value))
    override val ontapVolumeType: Optional[zio.aws.fsx.model.OntapVolumeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ontapVolumeType())
        .map(value => zio.aws.fsx.model.OntapVolumeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.OntapVolumeConfiguration
  ): zio.aws.fsx.model.OntapVolumeConfiguration.ReadOnly = new Wrapper(impl)
}
