package zio.aws.fsx.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.fsx.model.primitives.IntegerNoMax
import scala.jdk.CollectionConverters.*
final case class OpenZFSUserOrGroupQuota(
    `type`: zio.aws.fsx.model.OpenZFSQuotaType,
    id: IntegerNoMax,
    storageCapacityQuotaGiB: IntegerNoMax
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.OpenZFSUserOrGroupQuota = {
    import OpenZFSUserOrGroupQuota.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.OpenZFSUserOrGroupQuota
      .builder()
      .`type`(`type`.unwrap)
      .id(IntegerNoMax.unwrap(id): Integer)
      .storageCapacityQuotaGiB(
        IntegerNoMax.unwrap(storageCapacityQuotaGiB): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly =
    zio.aws.fsx.model.OpenZFSUserOrGroupQuota.wrap(buildAwsValue())
}
object OpenZFSUserOrGroupQuota {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.OpenZFSUserOrGroupQuota
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.OpenZFSUserOrGroupQuota =
      zio.aws.fsx.model
        .OpenZFSUserOrGroupQuota(`type`, id, storageCapacityQuotaGiB)
    def `type`: zio.aws.fsx.model.OpenZFSQuotaType
    def id: IntegerNoMax
    def storageCapacityQuotaGiB: IntegerNoMax
    def getType: ZIO[Any, Nothing, zio.aws.fsx.model.OpenZFSQuotaType] =
      ZIO.succeed(`type`)
    def getId: ZIO[Any, Nothing, IntegerNoMax] = ZIO.succeed(id)
    def getStorageCapacityQuotaGiB: ZIO[Any, Nothing, IntegerNoMax] =
      ZIO.succeed(storageCapacityQuotaGiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSUserOrGroupQuota
  ) extends zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly {
    override val `type`: zio.aws.fsx.model.OpenZFSQuotaType =
      zio.aws.fsx.model.OpenZFSQuotaType.wrap(impl.`type`())
    override val id: IntegerNoMax =
      zio.aws.fsx.model.primitives.IntegerNoMax(impl.id())
    override val storageCapacityQuotaGiB: IntegerNoMax =
      zio.aws.fsx.model.primitives.IntegerNoMax(impl.storageCapacityQuotaGiB())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSUserOrGroupQuota
  ): zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly = new Wrapper(impl)
}
