package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait ReportFormat {
  def unwrap: software.amazon.awssdk.services.fsx.model.ReportFormat
}
object ReportFormat {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.ReportFormat
  ): zio.aws.fsx.model.ReportFormat = value match {
    case software.amazon.awssdk.services.fsx.model.ReportFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.ReportFormat.REPORT_CSV_20191124 =>
      val r = REPORT_CSV_20191124
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.ReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.ReportFormat =
      software.amazon.awssdk.services.fsx.model.ReportFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object REPORT_CSV_20191124 extends zio.aws.fsx.model.ReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.ReportFormat =
      software.amazon.awssdk.services.fsx.model.ReportFormat.REPORT_CSV_20191124
  }
}
