package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait ReportScope {
  def unwrap: software.amazon.awssdk.services.fsx.model.ReportScope
}
object ReportScope {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.ReportScope
  ): zio.aws.fsx.model.ReportScope = value match {
    case software.amazon.awssdk.services.fsx.model.ReportScope.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.ReportScope.FAILED_FILES_ONLY =>
      val r = FAILED_FILES_ONLY
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.ReportScope {
    override def unwrap: software.amazon.awssdk.services.fsx.model.ReportScope =
      software.amazon.awssdk.services.fsx.model.ReportScope.UNKNOWN_TO_SDK_VERSION
  }
  case object FAILED_FILES_ONLY extends zio.aws.fsx.model.ReportScope {
    override def unwrap: software.amazon.awssdk.services.fsx.model.ReportScope =
      software.amazon.awssdk.services.fsx.model.ReportScope.FAILED_FILES_ONLY
  }
}
