package zio.aws.fsx.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  CreationTime,
  SnapshotName,
  ResourceARN,
  VolumeId,
  SnapshotId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Snapshot(
    resourceARN: Optional[ResourceARN] = Optional.Absent,
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    name: Optional[SnapshotName] = Optional.Absent,
    volumeId: Optional[VolumeId] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    lifecycle: Optional[zio.aws.fsx.model.SnapshotLifecycle] = Optional.Absent,
    lifecycleTransitionReason: Optional[
      zio.aws.fsx.model.LifecycleTransitionReason
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent,
    administrativeActions: Optional[
      Iterable[zio.aws.fsx.model.AdministrativeAction]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.fsx.model.Snapshot = {
    import Snapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.Snapshot
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        name.map(value => SnapshotName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        volumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.volumeId)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(
        lifecycleTransitionReason.map(value => value.buildAwsValue())
      )(_.lifecycleTransitionReason)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        administrativeActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.administrativeActions)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.Snapshot.ReadOnly =
    zio.aws.fsx.model.Snapshot.wrap(buildAwsValue())
}
object Snapshot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.Snapshot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.Snapshot = zio.aws.fsx.model.Snapshot(
      resourceARN.map(value => value),
      snapshotId.map(value => value),
      name.map(value => value),
      volumeId.map(value => value),
      creationTime.map(value => value),
      lifecycle.map(value => value),
      lifecycleTransitionReason.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      administrativeActions.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def resourceARN: Optional[ResourceARN]
    def snapshotId: Optional[SnapshotId]
    def name: Optional[SnapshotName]
    def volumeId: Optional[VolumeId]
    def creationTime: Optional[CreationTime]
    def lifecycle: Optional[zio.aws.fsx.model.SnapshotLifecycle]
    def lifecycleTransitionReason
        : Optional[zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def administrativeActions
        : Optional[List[zio.aws.fsx.model.AdministrativeAction.ReadOnly]]
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getName: ZIO[Any, AwsError, SnapshotName] =
      AwsError.unwrapOptionField("name", name)
    def getVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLifecycle: ZIO[Any, AwsError, zio.aws.fsx.model.SnapshotLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getLifecycleTransitionReason: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lifecycleTransitionReason",
      lifecycleTransitionReason
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAdministrativeActions: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.AdministrativeAction.ReadOnly
    ]] =
      AwsError.unwrapOptionField("administrativeActions", administrativeActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.Snapshot
  ) extends zio.aws.fsx.model.Snapshot.ReadOnly {
    override val resourceARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.fsx.model.primitives.SnapshotId(value))
    override val name: Optional[SnapshotName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.fsx.model.primitives.SnapshotName(value))
    override val volumeId: Optional[VolumeId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => zio.aws.fsx.model.primitives.VolumeId(value))
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.fsx.model.primitives.CreationTime(value))
    override val lifecycle: Optional[zio.aws.fsx.model.SnapshotLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.fsx.model.SnapshotLifecycle.wrap(value))
    override val lifecycleTransitionReason
        : Optional[zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleTransitionReason())
        .map(value => zio.aws.fsx.model.LifecycleTransitionReason.wrap(value))
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
    override val administrativeActions
        : Optional[List[zio.aws.fsx.model.AdministrativeAction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.administrativeActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.AdministrativeAction.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.Snapshot
  ): zio.aws.fsx.model.Snapshot.ReadOnly = new Wrapper(impl)
}
