package zio.aws.fsx.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  CreationTime,
  StorageVirtualMachineId,
  FileSystemId,
  StorageVirtualMachineName,
  ResourceARN,
  UUID
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class StorageVirtualMachine(
    activeDirectoryConfiguration: Optional[
      zio.aws.fsx.model.SvmActiveDirectoryConfiguration
    ] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    endpoints: Optional[zio.aws.fsx.model.SvmEndpoints] = Optional.Absent,
    fileSystemId: Optional[FileSystemId] = Optional.Absent,
    lifecycle: Optional[zio.aws.fsx.model.StorageVirtualMachineLifecycle] =
      Optional.Absent,
    name: Optional[StorageVirtualMachineName] = Optional.Absent,
    resourceARN: Optional[ResourceARN] = Optional.Absent,
    storageVirtualMachineId: Optional[StorageVirtualMachineId] =
      Optional.Absent,
    subtype: Optional[zio.aws.fsx.model.StorageVirtualMachineSubtype] =
      Optional.Absent,
    uuid: Optional[UUID] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent,
    lifecycleTransitionReason: Optional[
      zio.aws.fsx.model.LifecycleTransitionReason
    ] = Optional.Absent,
    rootVolumeSecurityStyle: Optional[
      zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.StorageVirtualMachine = {
    import StorageVirtualMachine.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.StorageVirtualMachine
      .builder()
      .optionallyWith(
        activeDirectoryConfiguration.map(value => value.buildAwsValue())
      )(_.activeDirectoryConfiguration)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(endpoints.map(value => value.buildAwsValue()))(
        _.endpoints
      )
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(
        name.map(value =>
          StorageVirtualMachineName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        storageVirtualMachineId.map(value =>
          StorageVirtualMachineId.unwrap(value): java.lang.String
        )
      )(_.storageVirtualMachineId)
      .optionallyWith(subtype.map(value => value.unwrap))(_.subtype)
      .optionallyWith(uuid.map(value => UUID.unwrap(value): java.lang.String))(
        _.uuid
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        lifecycleTransitionReason.map(value => value.buildAwsValue())
      )(_.lifecycleTransitionReason)
      .optionallyWith(rootVolumeSecurityStyle.map(value => value.unwrap))(
        _.rootVolumeSecurityStyle
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.StorageVirtualMachine.ReadOnly =
    zio.aws.fsx.model.StorageVirtualMachine.wrap(buildAwsValue())
}
object StorageVirtualMachine {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.StorageVirtualMachine
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.StorageVirtualMachine =
      zio.aws.fsx.model.StorageVirtualMachine(
        activeDirectoryConfiguration.map(value => value.asEditable),
        creationTime.map(value => value),
        endpoints.map(value => value.asEditable),
        fileSystemId.map(value => value),
        lifecycle.map(value => value),
        name.map(value => value),
        resourceARN.map(value => value),
        storageVirtualMachineId.map(value => value),
        subtype.map(value => value),
        uuid.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lifecycleTransitionReason.map(value => value.asEditable),
        rootVolumeSecurityStyle.map(value => value)
      )
    def activeDirectoryConfiguration
        : Optional[zio.aws.fsx.model.SvmActiveDirectoryConfiguration.ReadOnly]
    def creationTime: Optional[CreationTime]
    def endpoints: Optional[zio.aws.fsx.model.SvmEndpoints.ReadOnly]
    def fileSystemId: Optional[FileSystemId]
    def lifecycle: Optional[zio.aws.fsx.model.StorageVirtualMachineLifecycle]
    def name: Optional[StorageVirtualMachineName]
    def resourceARN: Optional[ResourceARN]
    def storageVirtualMachineId: Optional[StorageVirtualMachineId]
    def subtype: Optional[zio.aws.fsx.model.StorageVirtualMachineSubtype]
    def uuid: Optional[UUID]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def lifecycleTransitionReason
        : Optional[zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly]
    def rootVolumeSecurityStyle: Optional[
      zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
    ]
    def getActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.SvmActiveDirectoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "activeDirectoryConfiguration",
      activeDirectoryConfiguration
    )
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEndpoints
        : ZIO[Any, AwsError, zio.aws.fsx.model.SvmEndpoints.ReadOnly] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.fsx.model.StorageVirtualMachineLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getName: ZIO[Any, AwsError, StorageVirtualMachineName] =
      AwsError.unwrapOptionField("name", name)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getStorageVirtualMachineId
        : ZIO[Any, AwsError, StorageVirtualMachineId] = AwsError
      .unwrapOptionField("storageVirtualMachineId", storageVirtualMachineId)
    def getSubtype
        : ZIO[Any, AwsError, zio.aws.fsx.model.StorageVirtualMachineSubtype] =
      AwsError.unwrapOptionField("subtype", subtype)
    def getUuid: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("uuid", uuid)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getLifecycleTransitionReason: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lifecycleTransitionReason",
      lifecycleTransitionReason
    )
    def getRootVolumeSecurityStyle: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
    ] = AwsError.unwrapOptionField(
      "rootVolumeSecurityStyle",
      rootVolumeSecurityStyle
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.StorageVirtualMachine
  ) extends zio.aws.fsx.model.StorageVirtualMachine.ReadOnly {
    override val activeDirectoryConfiguration
        : Optional[zio.aws.fsx.model.SvmActiveDirectoryConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeDirectoryConfiguration())
        .map(value =>
          zio.aws.fsx.model.SvmActiveDirectoryConfiguration.wrap(value)
        )
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.fsx.model.primitives.CreationTime(value))
    override val endpoints: Optional[zio.aws.fsx.model.SvmEndpoints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoints())
        .map(value => zio.aws.fsx.model.SvmEndpoints.wrap(value))
    override val fileSystemId: Optional[FileSystemId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => zio.aws.fsx.model.primitives.FileSystemId(value))
    override val lifecycle
        : Optional[zio.aws.fsx.model.StorageVirtualMachineLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value =>
          zio.aws.fsx.model.StorageVirtualMachineLifecycle.wrap(value)
        )
    override val name: Optional[StorageVirtualMachineName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.fsx.model.primitives.StorageVirtualMachineName(value)
        )
    override val resourceARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
    override val storageVirtualMachineId: Optional[StorageVirtualMachineId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageVirtualMachineId())
        .map(value =>
          zio.aws.fsx.model.primitives.StorageVirtualMachineId(value)
        )
    override val subtype
        : Optional[zio.aws.fsx.model.StorageVirtualMachineSubtype] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subtype())
        .map(value =>
          zio.aws.fsx.model.StorageVirtualMachineSubtype.wrap(value)
        )
    override val uuid: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.uuid())
      .map(value => zio.aws.fsx.model.primitives.UUID(value))
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
    override val lifecycleTransitionReason
        : Optional[zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycleTransitionReason())
        .map(value => zio.aws.fsx.model.LifecycleTransitionReason.wrap(value))
    override val rootVolumeSecurityStyle: Optional[
      zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rootVolumeSecurityStyle())
      .map(value =>
        zio.aws.fsx.model.StorageVirtualMachineRootVolumeSecurityStyle
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.StorageVirtualMachine
  ): zio.aws.fsx.model.StorageVirtualMachine.ReadOnly = new Wrapper(impl)
}
