package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{IpAddress, DNSName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SvmEndpoint(
    dnsName: Optional[DNSName] = Optional.Absent,
    ipAddresses: Optional[Iterable[IpAddress]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.fsx.model.SvmEndpoint = {
    import SvmEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.SvmEndpoint
      .builder()
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        ipAddresses.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipAddresses)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.SvmEndpoint.ReadOnly =
    zio.aws.fsx.model.SvmEndpoint.wrap(buildAwsValue())
}
object SvmEndpoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.SvmEndpoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.SvmEndpoint = zio.aws.fsx.model
      .SvmEndpoint(dnsName.map(value => value), ipAddresses.map(value => value))
    def dnsName: Optional[DNSName]
    def ipAddresses: Optional[List[IpAddress]]
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getIpAddresses: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("ipAddresses", ipAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.SvmEndpoint
  ) extends zio.aws.fsx.model.SvmEndpoint.ReadOnly {
    override val dnsName: Optional[DNSName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.fsx.model.primitives.DNSName(value))
    override val ipAddresses: Optional[List[IpAddress]] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.IpAddress(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.SvmEndpoint
  ): zio.aws.fsx.model.SvmEndpoint.ReadOnly = new Wrapper(impl)
}
