package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait TieringPolicyName {
  def unwrap: software.amazon.awssdk.services.fsx.model.TieringPolicyName
}
object TieringPolicyName {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.TieringPolicyName
  ): zio.aws.fsx.model.TieringPolicyName = value match {
    case software.amazon.awssdk.services.fsx.model.TieringPolicyName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.TieringPolicyName.SNAPSHOT_ONLY =>
      val r = SNAPSHOT_ONLY
      r
    case software.amazon.awssdk.services.fsx.model.TieringPolicyName.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.fsx.model.TieringPolicyName.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.fsx.model.TieringPolicyName.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.TieringPolicyName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.TieringPolicyName =
      software.amazon.awssdk.services.fsx.model.TieringPolicyName.UNKNOWN_TO_SDK_VERSION
  }
  case object SNAPSHOT_ONLY extends zio.aws.fsx.model.TieringPolicyName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.TieringPolicyName =
      software.amazon.awssdk.services.fsx.model.TieringPolicyName.SNAPSHOT_ONLY
  }
  case object AUTO extends zio.aws.fsx.model.TieringPolicyName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.TieringPolicyName =
      software.amazon.awssdk.services.fsx.model.TieringPolicyName.AUTO
  }
  case object ALL extends zio.aws.fsx.model.TieringPolicyName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.TieringPolicyName =
      software.amazon.awssdk.services.fsx.model.TieringPolicyName.ALL
  }
  case object NONE extends zio.aws.fsx.model.TieringPolicyName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.TieringPolicyName =
      software.amazon.awssdk.services.fsx.model.TieringPolicyName.NONE
  }
}
