package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.fsx.model.primitives.{TagKey, ResourceARN}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceARN: ResourceARN,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UntagResourceRequest
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UntagResourceRequest.ReadOnly =
    zio.aws.fsx.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UntagResourceRequest =
      zio.aws.fsx.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: ResourceARN
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UntagResourceRequest
  ) extends zio.aws.fsx.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.fsx.model.primitives.ResourceARN(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.fsx.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UntagResourceRequest
  ): zio.aws.fsx.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
