package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSnapshotResponse(
    snapshot: Optional[zio.aws.fsx.model.Snapshot] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse = {
    import UpdateSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.UpdateSnapshotResponse.ReadOnly =
    zio.aws.fsx.model.UpdateSnapshotResponse.wrap(buildAwsValue())
}
object UpdateSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateSnapshotResponse = zio.aws.fsx.model
      .UpdateSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Optional[zio.aws.fsx.model.Snapshot.ReadOnly]
    def getSnapshot: ZIO[Any, AwsError, zio.aws.fsx.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse
  ) extends zio.aws.fsx.model.UpdateSnapshotResponse.ReadOnly {
    override val snapshot: Optional[zio.aws.fsx.model.Snapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshot())
        .map(value => zio.aws.fsx.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateSnapshotResponse
  ): zio.aws.fsx.model.UpdateSnapshotResponse.ReadOnly = new Wrapper(impl)
}
