package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateStorageVirtualMachineResponse(
    storageVirtualMachine: Optional[zio.aws.fsx.model.StorageVirtualMachine] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse = {
    import UpdateStorageVirtualMachineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse
      .builder()
      .optionallyWith(
        storageVirtualMachine.map(value => value.buildAwsValue())
      )(_.storageVirtualMachine)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.ReadOnly =
    zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.wrap(buildAwsValue())
}
object UpdateStorageVirtualMachineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateStorageVirtualMachineResponse =
      zio.aws.fsx.model.UpdateStorageVirtualMachineResponse(
        storageVirtualMachine.map(value => value.asEditable)
      )
    def storageVirtualMachine
        : Optional[zio.aws.fsx.model.StorageVirtualMachine.ReadOnly]
    def getStorageVirtualMachine
        : ZIO[Any, AwsError, zio.aws.fsx.model.StorageVirtualMachine.ReadOnly] =
      AwsError.unwrapOptionField("storageVirtualMachine", storageVirtualMachine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse
  ) extends zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.ReadOnly {
    override val storageVirtualMachine
        : Optional[zio.aws.fsx.model.StorageVirtualMachine.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageVirtualMachine())
        .map(value => zio.aws.fsx.model.StorageVirtualMachine.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateStorageVirtualMachineResponse
  ): zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.ReadOnly =
    new Wrapper(impl)
}
