package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait VolumeLifecycle {
  def unwrap: software.amazon.awssdk.services.fsx.model.VolumeLifecycle
}
object VolumeLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.VolumeLifecycle
  ): zio.aws.fsx.model.VolumeLifecycle = value match {
    case software.amazon.awssdk.services.fsx.model.VolumeLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.VolumeLifecycle.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.fsx.model.VolumeLifecycle.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.fsx.model.VolumeLifecycle.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.fsx.model.VolumeLifecycle.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.fsx.model.VolumeLifecycle.MISCONFIGURED =>
      val r = MISCONFIGURED
      r
    case software.amazon.awssdk.services.fsx.model.VolumeLifecycle.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.fsx.model.VolumeLifecycle.AVAILABLE =>
      val r = AVAILABLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.VolumeLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.VolumeLifecycle =
      software.amazon.awssdk.services.fsx.model.VolumeLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.fsx.model.VolumeLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.VolumeLifecycle =
      software.amazon.awssdk.services.fsx.model.VolumeLifecycle.CREATING
  }
  case object CREATED extends zio.aws.fsx.model.VolumeLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.VolumeLifecycle =
      software.amazon.awssdk.services.fsx.model.VolumeLifecycle.CREATED
  }
  case object DELETING extends zio.aws.fsx.model.VolumeLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.VolumeLifecycle =
      software.amazon.awssdk.services.fsx.model.VolumeLifecycle.DELETING
  }
  case object FAILED extends zio.aws.fsx.model.VolumeLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.VolumeLifecycle =
      software.amazon.awssdk.services.fsx.model.VolumeLifecycle.FAILED
  }
  case object MISCONFIGURED extends zio.aws.fsx.model.VolumeLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.VolumeLifecycle =
      software.amazon.awssdk.services.fsx.model.VolumeLifecycle.MISCONFIGURED
  }
  case object PENDING extends zio.aws.fsx.model.VolumeLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.VolumeLifecycle =
      software.amazon.awssdk.services.fsx.model.VolumeLifecycle.PENDING
  }
  case object AVAILABLE extends zio.aws.fsx.model.VolumeLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.VolumeLifecycle =
      software.amazon.awssdk.services.fsx.model.VolumeLifecycle.AVAILABLE
  }
}
