package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  SubnetId,
  DNSName,
  DailyTime,
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  WeeklyTime,
  IpAddress,
  Flag,
  DirectoryId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class WindowsFileSystemConfiguration(
    activeDirectoryId: Optional[DirectoryId] = Optional.Absent,
    selfManagedActiveDirectoryConfiguration: Optional[
      zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes
    ] = Optional.Absent,
    deploymentType: Optional[zio.aws.fsx.model.WindowsDeploymentType] =
      Optional.Absent,
    remoteAdministrationEndpoint: Optional[DNSName] = Optional.Absent,
    preferredSubnetId: Optional[SubnetId] = Optional.Absent,
    preferredFileServerIp: Optional[IpAddress] = Optional.Absent,
    throughputCapacity: Optional[MegabytesPerSecond] = Optional.Absent,
    maintenanceOperationsInProgress: Optional[
      Iterable[zio.aws.fsx.model.FileSystemMaintenanceOperation]
    ] = Optional.Absent,
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent,
    dailyAutomaticBackupStartTime: Optional[DailyTime] = Optional.Absent,
    automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays] =
      Optional.Absent,
    copyTagsToBackups: Optional[Flag] = Optional.Absent,
    aliases: Optional[Iterable[zio.aws.fsx.model.Alias]] = Optional.Absent,
    auditLogConfiguration: Optional[
      zio.aws.fsx.model.WindowsAuditLogConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.WindowsFileSystemConfiguration = {
    import WindowsFileSystemConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.WindowsFileSystemConfiguration
      .builder()
      .optionallyWith(
        activeDirectoryId.map(value =>
          DirectoryId.unwrap(value): java.lang.String
        )
      )(_.activeDirectoryId)
      .optionallyWith(
        selfManagedActiveDirectoryConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.selfManagedActiveDirectoryConfiguration)
      .optionallyWith(deploymentType.map(value => value.unwrap))(
        _.deploymentType
      )
      .optionallyWith(
        remoteAdministrationEndpoint.map(value =>
          DNSName.unwrap(value): java.lang.String
        )
      )(_.remoteAdministrationEndpoint)
      .optionallyWith(
        preferredSubnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.preferredSubnetId)
      .optionallyWith(
        preferredFileServerIp.map(value =>
          IpAddress.unwrap(value): java.lang.String
        )
      )(_.preferredFileServerIp)
      .optionallyWith(
        throughputCapacity.map(value =>
          MegabytesPerSecond.unwrap(value): Integer
        )
      )(_.throughputCapacity)
      .optionallyWith(
        maintenanceOperationsInProgress.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.maintenanceOperationsInProgressWithStrings)
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .optionallyWith(
        aliases.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aliases)
      .optionallyWith(
        auditLogConfiguration.map(value => value.buildAwsValue())
      )(_.auditLogConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.WindowsFileSystemConfiguration.ReadOnly =
    zio.aws.fsx.model.WindowsFileSystemConfiguration.wrap(buildAwsValue())
}
object WindowsFileSystemConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.WindowsFileSystemConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.WindowsFileSystemConfiguration =
      zio.aws.fsx.model.WindowsFileSystemConfiguration(
        activeDirectoryId.map(value => value),
        selfManagedActiveDirectoryConfiguration.map(value => value.asEditable),
        deploymentType.map(value => value),
        remoteAdministrationEndpoint.map(value => value),
        preferredSubnetId.map(value => value),
        preferredFileServerIp.map(value => value),
        throughputCapacity.map(value => value),
        maintenanceOperationsInProgress.map(value => value),
        weeklyMaintenanceStartTime.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        automaticBackupRetentionDays.map(value => value),
        copyTagsToBackups.map(value => value),
        aliases.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        auditLogConfiguration.map(value => value.asEditable)
      )
    def activeDirectoryId: Optional[DirectoryId]
    def selfManagedActiveDirectoryConfiguration: Optional[
      zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.ReadOnly
    ]
    def deploymentType: Optional[zio.aws.fsx.model.WindowsDeploymentType]
    def remoteAdministrationEndpoint: Optional[DNSName]
    def preferredSubnetId: Optional[SubnetId]
    def preferredFileServerIp: Optional[IpAddress]
    def throughputCapacity: Optional[MegabytesPerSecond]
    def maintenanceOperationsInProgress
        : Optional[List[zio.aws.fsx.model.FileSystemMaintenanceOperation]]
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def dailyAutomaticBackupStartTime: Optional[DailyTime]
    def automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays]
    def copyTagsToBackups: Optional[Flag]
    def aliases: Optional[List[zio.aws.fsx.model.Alias.ReadOnly]]
    def auditLogConfiguration
        : Optional[zio.aws.fsx.model.WindowsAuditLogConfiguration.ReadOnly]
    def getActiveDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("activeDirectoryId", activeDirectoryId)
    def getSelfManagedActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfManagedActiveDirectoryConfiguration",
      selfManagedActiveDirectoryConfiguration
    )
    def getDeploymentType
        : ZIO[Any, AwsError, zio.aws.fsx.model.WindowsDeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getRemoteAdministrationEndpoint: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField(
        "remoteAdministrationEndpoint",
        remoteAdministrationEndpoint
      )
    def getPreferredSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("preferredSubnetId", preferredSubnetId)
    def getPreferredFileServerIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("preferredFileServerIp", preferredFileServerIp)
    def getThroughputCapacity: ZIO[Any, AwsError, MegabytesPerSecond] =
      AwsError.unwrapOptionField("throughputCapacity", throughputCapacity)
    def getMaintenanceOperationsInProgress: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.FileSystemMaintenanceOperation
    ]] = AwsError.unwrapOptionField(
      "maintenanceOperationsInProgress",
      maintenanceOperationsInProgress
    )
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
    def getAliases: ZIO[Any, AwsError, List[zio.aws.fsx.model.Alias.ReadOnly]] =
      AwsError.unwrapOptionField("aliases", aliases)
    def getAuditLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.WindowsAuditLogConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("auditLogConfiguration", auditLogConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.WindowsFileSystemConfiguration
  ) extends zio.aws.fsx.model.WindowsFileSystemConfiguration.ReadOnly {
    override val activeDirectoryId: Optional[DirectoryId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeDirectoryId())
        .map(value => zio.aws.fsx.model.primitives.DirectoryId(value))
    override val selfManagedActiveDirectoryConfiguration: Optional[
      zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.selfManagedActiveDirectoryConfiguration())
      .map(value =>
        zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.wrap(value)
      )
    override val deploymentType
        : Optional[zio.aws.fsx.model.WindowsDeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentType())
        .map(value => zio.aws.fsx.model.WindowsDeploymentType.wrap(value))
    override val remoteAdministrationEndpoint: Optional[DNSName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteAdministrationEndpoint())
        .map(value => zio.aws.fsx.model.primitives.DNSName(value))
    override val preferredSubnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredSubnetId())
      .map(value => zio.aws.fsx.model.primitives.SubnetId(value))
    override val preferredFileServerIp: Optional[IpAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredFileServerIp())
        .map(value => zio.aws.fsx.model.primitives.IpAddress(value))
    override val throughputCapacity: Optional[MegabytesPerSecond] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputCapacity())
        .map(value => zio.aws.fsx.model.primitives.MegabytesPerSecond(value))
    override val maintenanceOperationsInProgress
        : Optional[List[zio.aws.fsx.model.FileSystemMaintenanceOperation]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maintenanceOperationsInProgress())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.FileSystemMaintenanceOperation.wrap(item)
          }.toList
        )
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val dailyAutomaticBackupStartTime: Optional[DailyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dailyAutomaticBackupStartTime())
        .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val automaticBackupRetentionDays
        : Optional[AutomaticBackupRetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val copyTagsToBackups: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val aliases: Optional[List[zio.aws.fsx.model.Alias.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Alias.wrap(item)
          }.toList
        )
    override val auditLogConfiguration
        : Optional[zio.aws.fsx.model.WindowsAuditLogConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditLogConfiguration())
        .map(value =>
          zio.aws.fsx.model.WindowsAuditLogConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.WindowsFileSystemConfiguration
  ): zio.aws.fsx.model.WindowsFileSystemConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
