package zio.aws.fsx
import zio.prelude.Subtype
import zio.aws.fsx.model.primitives.{
  SubnetId,
  StorageVirtualMachineFilterValue,
  DataRepositoryTaskFilterValue,
  AlternateDNSName,
  SecurityGroupId,
  NetworkInterfaceId,
  StorageVirtualMachineId,
  RouteTableId,
  BackupId,
  FileSystemId,
  SnapshotFilterValue,
  IpAddress,
  VolumeId,
  SnapshotId,
  VolumeFilterValue,
  FilterValue,
  OpenZFSNfsExportOption,
  DataRepositoryAssociationId,
  TaskId,
  TagKey,
  DataRepositoryTaskPath
}
import java.time.Instant
import zio.aws.fsx.model.primitives.WeeklyTime.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AWSAccountId extends Subtype[String]
    type AWSAccountId = zio.aws.fsx.model.primitives.AWSAccountId.Type
    object ActiveDirectoryFullyQualifiedName extends Subtype[String]
    type ActiveDirectoryFullyQualifiedName =
      zio.aws.fsx.model.primitives.ActiveDirectoryFullyQualifiedName.Type
    object AdminPassword extends Subtype[String]
    type AdminPassword = zio.aws.fsx.model.primitives.AdminPassword.Type
    object AlternateDNSName extends Subtype[String]
    type AlternateDNSName = zio.aws.fsx.model.primitives.AlternateDNSName.Type
    object ArchivePath extends Subtype[String]
    type ArchivePath = zio.aws.fsx.model.primitives.ArchivePath.Type
    object AutomaticBackupRetentionDays extends Subtype[Int]
    type AutomaticBackupRetentionDays =
      zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays.Type
    object BackupId extends Subtype[String]
    type BackupId = zio.aws.fsx.model.primitives.BackupId.Type
    object BatchImportMetaDataOnCreate extends Subtype[Boolean]
    type BatchImportMetaDataOnCreate =
      zio.aws.fsx.model.primitives.BatchImportMetaDataOnCreate.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.fsx.model.primitives.ClientRequestToken.Type
    object CoolingPeriod extends Subtype[Int]
    type CoolingPeriod = zio.aws.fsx.model.primitives.CoolingPeriod.Type
    object CreationTime extends Subtype[Instant]
    type CreationTime = zio.aws.fsx.model.primitives.CreationTime.Type
    object DNSName extends Subtype[String]
    type DNSName = zio.aws.fsx.model.primitives.DNSName.Type
    object DailyTime extends Subtype[String]
    type DailyTime = zio.aws.fsx.model.primitives.DailyTime.Type
    object DataRepositoryAssociationId extends Subtype[String]
    type DataRepositoryAssociationId =
      zio.aws.fsx.model.primitives.DataRepositoryAssociationId.Type
    object DataRepositoryTaskFilterValue extends Subtype[String]
    type DataRepositoryTaskFilterValue =
      zio.aws.fsx.model.primitives.DataRepositoryTaskFilterValue.Type
    object DataRepositoryTaskPath extends Subtype[String]
    type DataRepositoryTaskPath =
      zio.aws.fsx.model.primitives.DataRepositoryTaskPath.Type
    object DeleteDataInFileSystem extends Subtype[Boolean]
    type DeleteDataInFileSystem =
      zio.aws.fsx.model.primitives.DeleteDataInFileSystem.Type
    object DirectoryId extends Subtype[String]
    type DirectoryId = zio.aws.fsx.model.primitives.DirectoryId.Type
    object DirectoryPassword extends Subtype[String]
    type DirectoryPassword = zio.aws.fsx.model.primitives.DirectoryPassword.Type
    object DirectoryUserName extends Subtype[String]
    type DirectoryUserName = zio.aws.fsx.model.primitives.DirectoryUserName.Type
    object EndTime extends Subtype[Instant]
    type EndTime = zio.aws.fsx.model.primitives.EndTime.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.fsx.model.primitives.ErrorMessage.Type
    object FailedCount extends Subtype[Long]
    type FailedCount = zio.aws.fsx.model.primitives.FailedCount.Type
    object FileSystemAdministratorsGroupName extends Subtype[String]
    type FileSystemAdministratorsGroupName =
      zio.aws.fsx.model.primitives.FileSystemAdministratorsGroupName.Type
    object FileSystemId extends Subtype[String]
    type FileSystemId = zio.aws.fsx.model.primitives.FileSystemId.Type
    object FileSystemTypeVersion extends Subtype[String]
    type FileSystemTypeVersion =
      zio.aws.fsx.model.primitives.FileSystemTypeVersion.Type
    object FilterValue extends Subtype[String]
    type FilterValue = zio.aws.fsx.model.primitives.FilterValue.Type
    object Flag extends Subtype[Boolean]
    type Flag = zio.aws.fsx.model.primitives.Flag.Type
    object GeneralARN extends Subtype[String]
    type GeneralARN = zio.aws.fsx.model.primitives.GeneralARN.Type
    object IntegerNoMax extends Subtype[Int]
    type IntegerNoMax = zio.aws.fsx.model.primitives.IntegerNoMax.Type
    object IntegerNoMaxFromNegativeOne extends Subtype[Int]
    type IntegerNoMaxFromNegativeOne =
      zio.aws.fsx.model.primitives.IntegerNoMaxFromNegativeOne.Type
    object IntegerRecordSizeKiB extends Subtype[Int]
    type IntegerRecordSizeKiB =
      zio.aws.fsx.model.primitives.IntegerRecordSizeKiB.Type
    object Iops extends Subtype[Long]
    type Iops = zio.aws.fsx.model.primitives.Iops.Type
    object IpAddress extends Subtype[String]
    type IpAddress = zio.aws.fsx.model.primitives.IpAddress.Type
    object IpAddressRange extends Subtype[String]
    type IpAddressRange = zio.aws.fsx.model.primitives.IpAddressRange.Type
    object JunctionPath extends Subtype[String]
    type JunctionPath = zio.aws.fsx.model.primitives.JunctionPath.Type
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.fsx.model.primitives.KmsKeyId.Type
    object LastUpdatedTime extends Subtype[Instant]
    type LastUpdatedTime = zio.aws.fsx.model.primitives.LastUpdatedTime.Type
    object LimitedMaxResults extends Subtype[Int]
    type LimitedMaxResults = zio.aws.fsx.model.primitives.LimitedMaxResults.Type
    object LustreFileSystemMountName extends Subtype[String]
    type LustreFileSystemMountName =
      zio.aws.fsx.model.primitives.LustreFileSystemMountName.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.fsx.model.primitives.MaxResults.Type
    object Megabytes extends Subtype[Int]
    type Megabytes = zio.aws.fsx.model.primitives.Megabytes.Type
    object MegabytesPerSecond extends Subtype[Int]
    type MegabytesPerSecond =
      zio.aws.fsx.model.primitives.MegabytesPerSecond.Type
    object Namespace extends Subtype[String]
    type Namespace = zio.aws.fsx.model.primitives.Namespace.Type
    object NetBiosAlias extends Subtype[String]
    type NetBiosAlias = zio.aws.fsx.model.primitives.NetBiosAlias.Type
    object NetworkInterfaceId extends Subtype[String]
    type NetworkInterfaceId =
      zio.aws.fsx.model.primitives.NetworkInterfaceId.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.fsx.model.primitives.NextToken.Type
    object OpenZFSClients extends Subtype[String]
    type OpenZFSClients = zio.aws.fsx.model.primitives.OpenZFSClients.Type
    object OpenZFSNfsExportOption extends Subtype[String]
    type OpenZFSNfsExportOption =
      zio.aws.fsx.model.primitives.OpenZFSNfsExportOption.Type
    object OrganizationalUnitDistinguishedName extends Subtype[String]
    type OrganizationalUnitDistinguishedName =
      zio.aws.fsx.model.primitives.OrganizationalUnitDistinguishedName.Type
    object PerUnitStorageThroughput extends Subtype[Int]
    type PerUnitStorageThroughput =
      zio.aws.fsx.model.primitives.PerUnitStorageThroughput.Type
    object ProgressPercent extends Subtype[Int]
    type ProgressPercent = zio.aws.fsx.model.primitives.ProgressPercent.Type
    object ReadOnly extends Subtype[Boolean]
    type ReadOnly = zio.aws.fsx.model.primitives.ReadOnly.Type
    object Region extends Subtype[String]
    type Region = zio.aws.fsx.model.primitives.Region.Type
    object RequestTime extends Subtype[Instant]
    type RequestTime = zio.aws.fsx.model.primitives.RequestTime.Type
    object ResourceARN extends Subtype[String]
    type ResourceARN = zio.aws.fsx.model.primitives.ResourceARN.Type
    object RouteTableId extends Subtype[String]
    type RouteTableId = zio.aws.fsx.model.primitives.RouteTableId.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId = zio.aws.fsx.model.primitives.SecurityGroupId.Type
    object SnapshotFilterValue extends Subtype[String]
    type SnapshotFilterValue =
      zio.aws.fsx.model.primitives.SnapshotFilterValue.Type
    object SnapshotId extends Subtype[String]
    type SnapshotId = zio.aws.fsx.model.primitives.SnapshotId.Type
    object SnapshotName extends Subtype[String]
    type SnapshotName = zio.aws.fsx.model.primitives.SnapshotName.Type
    object SourceBackupId extends Subtype[String]
    type SourceBackupId = zio.aws.fsx.model.primitives.SourceBackupId.Type
    object StartTime extends Subtype[Instant]
    type StartTime = zio.aws.fsx.model.primitives.StartTime.Type
    object StorageCapacity extends Subtype[Int]
    type StorageCapacity = zio.aws.fsx.model.primitives.StorageCapacity.Type
    object StorageVirtualMachineFilterValue extends Subtype[String]
    type StorageVirtualMachineFilterValue =
      zio.aws.fsx.model.primitives.StorageVirtualMachineFilterValue.Type
    object StorageVirtualMachineId extends Subtype[String]
    type StorageVirtualMachineId =
      zio.aws.fsx.model.primitives.StorageVirtualMachineId.Type
    object StorageVirtualMachineName extends Subtype[String]
    type StorageVirtualMachineName =
      zio.aws.fsx.model.primitives.StorageVirtualMachineName.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.fsx.model.primitives.SubnetId.Type
    object SucceededCount extends Subtype[Long]
    type SucceededCount = zio.aws.fsx.model.primitives.SucceededCount.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.fsx.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.fsx.model.primitives.TagValue.Type
    object TaskId extends Subtype[String]
    type TaskId = zio.aws.fsx.model.primitives.TaskId.Type
    object TotalCount extends Subtype[Long]
    type TotalCount = zio.aws.fsx.model.primitives.TotalCount.Type
    object UUID extends Subtype[String]
    type UUID = zio.aws.fsx.model.primitives.UUID.Type
    object VolumeCapacity extends Subtype[Int]
    type VolumeCapacity = zio.aws.fsx.model.primitives.VolumeCapacity.Type
    object VolumeFilterValue extends Subtype[String]
    type VolumeFilterValue = zio.aws.fsx.model.primitives.VolumeFilterValue.Type
    object VolumeId extends Subtype[String]
    type VolumeId = zio.aws.fsx.model.primitives.VolumeId.Type
    object VolumeName extends Subtype[String]
    type VolumeName = zio.aws.fsx.model.primitives.VolumeName.Type
    object VolumePath extends Subtype[String]
    type VolumePath = zio.aws.fsx.model.primitives.VolumePath.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.fsx.model.primitives.VpcId.Type
    object WeeklyTime extends Subtype[String]
    type WeeklyTime = zio.aws.fsx.model.primitives.WeeklyTime.Type
  }
  type AdministrativeActions = List[zio.aws.fsx.model.AdministrativeAction]
  type Aliases = List[zio.aws.fsx.model.Alias]
  type AlternateDNSNames = List[AlternateDNSName]
  type BackupIds = List[BackupId]
  type Backups = List[zio.aws.fsx.model.Backup]
  type DataRepositoryAssociationIds = List[DataRepositoryAssociationId]
  type DataRepositoryAssociations =
    List[zio.aws.fsx.model.DataRepositoryAssociation]
  type DataRepositoryTaskFilterValues = List[DataRepositoryTaskFilterValue]
  type DataRepositoryTaskFilters =
    List[zio.aws.fsx.model.DataRepositoryTaskFilter]
  type DataRepositoryTaskPaths = List[DataRepositoryTaskPath]
  type DataRepositoryTasks = List[zio.aws.fsx.model.DataRepositoryTask]
  type DeleteFileSystemOpenZFSOptions =
    List[zio.aws.fsx.model.DeleteFileSystemOpenZFSOption]
  type DeleteOpenZFSVolumeOptions =
    List[zio.aws.fsx.model.DeleteOpenZFSVolumeOption]
  type DnsIps = List[IpAddress]
  type EventTypes = List[zio.aws.fsx.model.EventType]
  type FileSystemIds = List[FileSystemId]
  type FileSystemMaintenanceOperations =
    List[zio.aws.fsx.model.FileSystemMaintenanceOperation]
  type FileSystems = List[zio.aws.fsx.model.FileSystem]
  type FilterValues = List[FilterValue]
  type Filters = List[zio.aws.fsx.model.Filter]
  type NetworkInterfaceIds = List[NetworkInterfaceId]
  type OntapEndpointIpAddresses = List[IpAddress]
  type OpenZFSClientConfigurations =
    List[zio.aws.fsx.model.OpenZFSClientConfiguration]
  type OpenZFSNfsExportOptions = List[OpenZFSNfsExportOption]
  type OpenZFSNfsExports = List[zio.aws.fsx.model.OpenZFSNfsExport]
  type OpenZFSUserAndGroupQuotas =
    List[zio.aws.fsx.model.OpenZFSUserOrGroupQuota]
  type RestoreOpenZFSVolumeOptions =
    List[zio.aws.fsx.model.RestoreOpenZFSVolumeOption]
  type RouteTableIds = List[RouteTableId]
  type SecurityGroupIds = List[SecurityGroupId]
  type SnapshotFilterValues = List[SnapshotFilterValue]
  type SnapshotFilters = List[zio.aws.fsx.model.SnapshotFilter]
  type SnapshotIds = List[SnapshotId]
  type Snapshots = List[zio.aws.fsx.model.Snapshot]
  type StorageVirtualMachineFilterValues =
    List[StorageVirtualMachineFilterValue]
  type StorageVirtualMachineFilters =
    List[zio.aws.fsx.model.StorageVirtualMachineFilter]
  type StorageVirtualMachineIds = List[StorageVirtualMachineId]
  type StorageVirtualMachines = List[zio.aws.fsx.model.StorageVirtualMachine]
  type SubnetIds = List[SubnetId]
  type TagKeys = List[TagKey]
  type Tags = List[zio.aws.fsx.model.Tag]
  type TaskIds = List[TaskId]
  type VolumeFilterValues = List[VolumeFilterValue]
  type VolumeFilters = List[zio.aws.fsx.model.VolumeFilter]
  type VolumeIds = List[VolumeId]
  type Volumes = List[zio.aws.fsx.model.Volume]
}
