package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateFileCacheResponse(
    fileCache: Optional[zio.aws.fsx.model.FileCacheCreating] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileCacheResponse = {
    import CreateFileCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileCacheResponse
      .builder()
      .optionallyWith(fileCache.map(value => value.buildAwsValue()))(
        _.fileCache
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateFileCacheResponse.ReadOnly =
    zio.aws.fsx.model.CreateFileCacheResponse.wrap(buildAwsValue())
}
object CreateFileCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileCacheResponse =
      zio.aws.fsx.model
        .CreateFileCacheResponse(fileCache.map(value => value.asEditable))
    def fileCache: Optional[zio.aws.fsx.model.FileCacheCreating.ReadOnly]
    def getFileCache
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileCacheCreating.ReadOnly] =
      AwsError.unwrapOptionField("fileCache", fileCache)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileCacheResponse
  ) extends zio.aws.fsx.model.CreateFileCacheResponse.ReadOnly {
    override val fileCache
        : Optional[zio.aws.fsx.model.FileCacheCreating.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileCache())
        .map(value => zio.aws.fsx.model.FileCacheCreating.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileCacheResponse
  ): zio.aws.fsx.model.CreateFileCacheResponse.ReadOnly = new Wrapper(impl)
}
