package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  JunctionPath,
  SnapshotPolicy,
  StorageVirtualMachineId,
  VolumeCapacity,
  Flag
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateOntapVolumeConfiguration(
    junctionPath: Optional[JunctionPath] = Optional.Absent,
    securityStyle: Optional[zio.aws.fsx.model.SecurityStyle] = Optional.Absent,
    sizeInMegabytes: VolumeCapacity,
    storageEfficiencyEnabled: Optional[Flag] = Optional.Absent,
    storageVirtualMachineId: StorageVirtualMachineId,
    tieringPolicy: Optional[zio.aws.fsx.model.TieringPolicy] = Optional.Absent,
    ontapVolumeType: Optional[zio.aws.fsx.model.InputOntapVolumeType] =
      Optional.Absent,
    snapshotPolicy: Optional[SnapshotPolicy] = Optional.Absent,
    copyTagsToBackups: Optional[Flag] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateOntapVolumeConfiguration = {
    import CreateOntapVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateOntapVolumeConfiguration
      .builder()
      .optionallyWith(
        junctionPath.map(value => JunctionPath.unwrap(value): java.lang.String)
      )(_.junctionPath)
      .optionallyWith(securityStyle.map(value => value.unwrap))(_.securityStyle)
      .sizeInMegabytes(VolumeCapacity.unwrap(sizeInMegabytes): Integer)
      .optionallyWith(
        storageEfficiencyEnabled.map(value =>
          Flag.unwrap(value): java.lang.Boolean
        )
      )(_.storageEfficiencyEnabled)
      .storageVirtualMachineId(
        StorageVirtualMachineId.unwrap(
          storageVirtualMachineId
        ): java.lang.String
      )
      .optionallyWith(tieringPolicy.map(value => value.buildAwsValue()))(
        _.tieringPolicy
      )
      .optionallyWith(ontapVolumeType.map(value => value.unwrap))(
        _.ontapVolumeType
      )
      .optionallyWith(
        snapshotPolicy.map(value =>
          SnapshotPolicy.unwrap(value): java.lang.String
        )
      )(_.snapshotPolicy)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateOntapVolumeConfiguration.ReadOnly =
    zio.aws.fsx.model.CreateOntapVolumeConfiguration.wrap(buildAwsValue())
}
object CreateOntapVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateOntapVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateOntapVolumeConfiguration =
      zio.aws.fsx.model.CreateOntapVolumeConfiguration(
        junctionPath.map(value => value),
        securityStyle.map(value => value),
        sizeInMegabytes,
        storageEfficiencyEnabled.map(value => value),
        storageVirtualMachineId,
        tieringPolicy.map(value => value.asEditable),
        ontapVolumeType.map(value => value),
        snapshotPolicy.map(value => value),
        copyTagsToBackups.map(value => value)
      )
    def junctionPath: Optional[JunctionPath]
    def securityStyle: Optional[zio.aws.fsx.model.SecurityStyle]
    def sizeInMegabytes: VolumeCapacity
    def storageEfficiencyEnabled: Optional[Flag]
    def storageVirtualMachineId: StorageVirtualMachineId
    def tieringPolicy: Optional[zio.aws.fsx.model.TieringPolicy.ReadOnly]
    def ontapVolumeType: Optional[zio.aws.fsx.model.InputOntapVolumeType]
    def snapshotPolicy: Optional[SnapshotPolicy]
    def copyTagsToBackups: Optional[Flag]
    def getJunctionPath: ZIO[Any, AwsError, JunctionPath] =
      AwsError.unwrapOptionField("junctionPath", junctionPath)
    def getSecurityStyle: ZIO[Any, AwsError, zio.aws.fsx.model.SecurityStyle] =
      AwsError.unwrapOptionField("securityStyle", securityStyle)
    def getSizeInMegabytes: ZIO[Any, Nothing, VolumeCapacity] =
      ZIO.succeed(sizeInMegabytes)
    def getStorageEfficiencyEnabled: ZIO[Any, AwsError, Flag] = AwsError
      .unwrapOptionField("storageEfficiencyEnabled", storageEfficiencyEnabled)
    def getStorageVirtualMachineId: ZIO[Any, Nothing, StorageVirtualMachineId] =
      ZIO.succeed(storageVirtualMachineId)
    def getTieringPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.TieringPolicy.ReadOnly] =
      AwsError.unwrapOptionField("tieringPolicy", tieringPolicy)
    def getOntapVolumeType
        : ZIO[Any, AwsError, zio.aws.fsx.model.InputOntapVolumeType] =
      AwsError.unwrapOptionField("ontapVolumeType", ontapVolumeType)
    def getSnapshotPolicy: ZIO[Any, AwsError, SnapshotPolicy] =
      AwsError.unwrapOptionField("snapshotPolicy", snapshotPolicy)
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateOntapVolumeConfiguration
  ) extends zio.aws.fsx.model.CreateOntapVolumeConfiguration.ReadOnly {
    override val junctionPath: Optional[JunctionPath] = zio.aws.core.internal
      .optionalFromNullable(impl.junctionPath())
      .map(value => zio.aws.fsx.model.primitives.JunctionPath(value))
    override val securityStyle: Optional[zio.aws.fsx.model.SecurityStyle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityStyle())
        .map(value => zio.aws.fsx.model.SecurityStyle.wrap(value))
    override val sizeInMegabytes: VolumeCapacity =
      zio.aws.fsx.model.primitives.VolumeCapacity(impl.sizeInMegabytes())
    override val storageEfficiencyEnabled: Optional[Flag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageEfficiencyEnabled())
        .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val storageVirtualMachineId: StorageVirtualMachineId =
      zio.aws.fsx.model.primitives
        .StorageVirtualMachineId(impl.storageVirtualMachineId())
    override val tieringPolicy
        : Optional[zio.aws.fsx.model.TieringPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tieringPolicy())
        .map(value => zio.aws.fsx.model.TieringPolicy.wrap(value))
    override val ontapVolumeType
        : Optional[zio.aws.fsx.model.InputOntapVolumeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ontapVolumeType())
        .map(value => zio.aws.fsx.model.InputOntapVolumeType.wrap(value))
    override val snapshotPolicy: Optional[SnapshotPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotPolicy())
        .map(value => zio.aws.fsx.model.primitives.SnapshotPolicy(value))
    override val copyTagsToBackups: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateOntapVolumeConfiguration
  ): zio.aws.fsx.model.CreateOntapVolumeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
