package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  IntegerNoMaxFromNegativeOne,
  IntegerRecordSizeKiB,
  Flag,
  VolumeId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateOpenZFSVolumeConfiguration(
    parentVolumeId: VolumeId,
    storageCapacityReservationGiB: Optional[IntegerNoMaxFromNegativeOne] =
      Optional.Absent,
    storageCapacityQuotaGiB: Optional[IntegerNoMaxFromNegativeOne] =
      Optional.Absent,
    recordSizeKiB: Optional[IntegerRecordSizeKiB] = Optional.Absent,
    dataCompressionType: Optional[
      zio.aws.fsx.model.OpenZFSDataCompressionType
    ] = Optional.Absent,
    copyTagsToSnapshots: Optional[Flag] = Optional.Absent,
    originSnapshot: Optional[
      zio.aws.fsx.model.CreateOpenZFSOriginSnapshotConfiguration
    ] = Optional.Absent,
    readOnly: Optional[zio.aws.fsx.model.primitives.ReadOnly] = Optional.Absent,
    nfsExports: Optional[Iterable[zio.aws.fsx.model.OpenZFSNfsExport]] =
      Optional.Absent,
    userAndGroupQuotas: Optional[
      Iterable[zio.aws.fsx.model.OpenZFSUserOrGroupQuota]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateOpenZFSVolumeConfiguration = {
    import CreateOpenZFSVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateOpenZFSVolumeConfiguration
      .builder()
      .parentVolumeId(VolumeId.unwrap(parentVolumeId): java.lang.String)
      .optionallyWith(
        storageCapacityReservationGiB.map(value =>
          IntegerNoMaxFromNegativeOne.unwrap(value): Integer
        )
      )(_.storageCapacityReservationGiB)
      .optionallyWith(
        storageCapacityQuotaGiB.map(value =>
          IntegerNoMaxFromNegativeOne.unwrap(value): Integer
        )
      )(_.storageCapacityQuotaGiB)
      .optionallyWith(
        recordSizeKiB.map(value => IntegerRecordSizeKiB.unwrap(value): Integer)
      )(_.recordSizeKiB)
      .optionallyWith(dataCompressionType.map(value => value.unwrap))(
        _.dataCompressionType
      )
      .optionallyWith(
        copyTagsToSnapshots.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToSnapshots)
      .optionallyWith(originSnapshot.map(value => value.buildAwsValue()))(
        _.originSnapshot
      )
      .optionallyWith(
        readOnly.map(value =>
          zio.aws.fsx.model.primitives.ReadOnly.unwrap(value): java.lang.Boolean
        )
      )(_.readOnly)
      .optionallyWith(
        nfsExports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nfsExports)
      .optionallyWith(
        userAndGroupQuotas.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userAndGroupQuotas)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateOpenZFSVolumeConfiguration.ReadOnly =
    zio.aws.fsx.model.CreateOpenZFSVolumeConfiguration.wrap(buildAwsValue())
}
object CreateOpenZFSVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateOpenZFSVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateOpenZFSVolumeConfiguration =
      zio.aws.fsx.model.CreateOpenZFSVolumeConfiguration(
        parentVolumeId,
        storageCapacityReservationGiB.map(value => value),
        storageCapacityQuotaGiB.map(value => value),
        recordSizeKiB.map(value => value),
        dataCompressionType.map(value => value),
        copyTagsToSnapshots.map(value => value),
        originSnapshot.map(value => value.asEditable),
        readOnly.map(value => value),
        nfsExports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userAndGroupQuotas.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parentVolumeId: VolumeId
    def storageCapacityReservationGiB: Optional[IntegerNoMaxFromNegativeOne]
    def storageCapacityQuotaGiB: Optional[IntegerNoMaxFromNegativeOne]
    def recordSizeKiB: Optional[IntegerRecordSizeKiB]
    def dataCompressionType
        : Optional[zio.aws.fsx.model.OpenZFSDataCompressionType]
    def copyTagsToSnapshots: Optional[Flag]
    def originSnapshot: Optional[
      zio.aws.fsx.model.CreateOpenZFSOriginSnapshotConfiguration.ReadOnly
    ]
    def readOnly: Optional[zio.aws.fsx.model.primitives.ReadOnly]
    def nfsExports: Optional[List[zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly]]
    def userAndGroupQuotas
        : Optional[List[zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly]]
    def getParentVolumeId: ZIO[Any, Nothing, VolumeId] =
      ZIO.succeed(parentVolumeId)
    def getStorageCapacityReservationGiB
        : ZIO[Any, AwsError, IntegerNoMaxFromNegativeOne] =
      AwsError.unwrapOptionField(
        "storageCapacityReservationGiB",
        storageCapacityReservationGiB
      )
    def getStorageCapacityQuotaGiB
        : ZIO[Any, AwsError, IntegerNoMaxFromNegativeOne] = AwsError
      .unwrapOptionField("storageCapacityQuotaGiB", storageCapacityQuotaGiB)
    def getRecordSizeKiB: ZIO[Any, AwsError, IntegerRecordSizeKiB] =
      AwsError.unwrapOptionField("recordSizeKiB", recordSizeKiB)
    def getDataCompressionType
        : ZIO[Any, AwsError, zio.aws.fsx.model.OpenZFSDataCompressionType] =
      AwsError.unwrapOptionField("dataCompressionType", dataCompressionType)
    def getCopyTagsToSnapshots: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToSnapshots", copyTagsToSnapshots)
    def getOriginSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateOpenZFSOriginSnapshotConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("originSnapshot", originSnapshot)
    def getReadOnly: ZIO[Any, AwsError, zio.aws.fsx.model.primitives.ReadOnly] =
      AwsError.unwrapOptionField("readOnly", readOnly)
    def getNfsExports: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly
    ]] = AwsError.unwrapOptionField("nfsExports", nfsExports)
    def getUserAndGroupQuotas: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly
    ]] = AwsError.unwrapOptionField("userAndGroupQuotas", userAndGroupQuotas)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateOpenZFSVolumeConfiguration
  ) extends zio.aws.fsx.model.CreateOpenZFSVolumeConfiguration.ReadOnly {
    override val parentVolumeId: VolumeId =
      zio.aws.fsx.model.primitives.VolumeId(impl.parentVolumeId())
    override val storageCapacityReservationGiB
        : Optional[IntegerNoMaxFromNegativeOne] = zio.aws.core.internal
      .optionalFromNullable(impl.storageCapacityReservationGiB())
      .map(value =>
        zio.aws.fsx.model.primitives.IntegerNoMaxFromNegativeOne(value)
      )
    override val storageCapacityQuotaGiB
        : Optional[IntegerNoMaxFromNegativeOne] = zio.aws.core.internal
      .optionalFromNullable(impl.storageCapacityQuotaGiB())
      .map(value =>
        zio.aws.fsx.model.primitives.IntegerNoMaxFromNegativeOne(value)
      )
    override val recordSizeKiB: Optional[IntegerRecordSizeKiB] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordSizeKiB())
        .map(value => zio.aws.fsx.model.primitives.IntegerRecordSizeKiB(value))
    override val dataCompressionType
        : Optional[zio.aws.fsx.model.OpenZFSDataCompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCompressionType())
        .map(value => zio.aws.fsx.model.OpenZFSDataCompressionType.wrap(value))
    override val copyTagsToSnapshots: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToSnapshots())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val originSnapshot: Optional[
      zio.aws.fsx.model.CreateOpenZFSOriginSnapshotConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.originSnapshot())
      .map(value =>
        zio.aws.fsx.model.CreateOpenZFSOriginSnapshotConfiguration.wrap(value)
      )
    override val readOnly: Optional[zio.aws.fsx.model.primitives.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readOnly())
        .map(value => zio.aws.fsx.model.primitives.ReadOnly(value))
    override val nfsExports
        : Optional[List[zio.aws.fsx.model.OpenZFSNfsExport.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nfsExports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.OpenZFSNfsExport.wrap(item)
          }.toList
        )
    override val userAndGroupQuotas
        : Optional[List[zio.aws.fsx.model.OpenZFSUserOrGroupQuota.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userAndGroupQuotas())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.OpenZFSUserOrGroupQuota.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateOpenZFSVolumeConfiguration
  ): zio.aws.fsx.model.CreateOpenZFSVolumeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
