package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{VolumeName, ClientRequestToken}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateVolumeRequest(
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    volumeType: zio.aws.fsx.model.VolumeType,
    name: VolumeName,
    ontapConfiguration: Optional[
      zio.aws.fsx.model.CreateOntapVolumeConfiguration
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent,
    openZFSConfiguration: Optional[
      zio.aws.fsx.model.CreateOpenZFSVolumeConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateVolumeRequest = {
    import CreateVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateVolumeRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .volumeType(volumeType.unwrap)
      .name(VolumeName.unwrap(name): java.lang.String)
      .optionallyWith(ontapConfiguration.map(value => value.buildAwsValue()))(
        _.ontapConfiguration
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(openZFSConfiguration.map(value => value.buildAwsValue()))(
        _.openZFSConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateVolumeRequest.ReadOnly =
    zio.aws.fsx.model.CreateVolumeRequest.wrap(buildAwsValue())
}
object CreateVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateVolumeRequest =
      zio.aws.fsx.model.CreateVolumeRequest(
        clientRequestToken.map(value => value),
        volumeType,
        name,
        ontapConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        openZFSConfiguration.map(value => value.asEditable)
      )
    def clientRequestToken: Optional[ClientRequestToken]
    def volumeType: zio.aws.fsx.model.VolumeType
    def name: VolumeName
    def ontapConfiguration
        : Optional[zio.aws.fsx.model.CreateOntapVolumeConfiguration.ReadOnly]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def openZFSConfiguration
        : Optional[zio.aws.fsx.model.CreateOpenZFSVolumeConfiguration.ReadOnly]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getVolumeType: ZIO[Any, Nothing, zio.aws.fsx.model.VolumeType] =
      ZIO.succeed(volumeType)
    def getName: ZIO[Any, Nothing, VolumeName] = ZIO.succeed(name)
    def getOntapConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateOntapVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ontapConfiguration", ontapConfiguration)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getOpenZFSConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateOpenZFSVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSConfiguration", openZFSConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateVolumeRequest
  ) extends zio.aws.fsx.model.CreateVolumeRequest.ReadOnly {
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val volumeType: zio.aws.fsx.model.VolumeType =
      zio.aws.fsx.model.VolumeType.wrap(impl.volumeType())
    override val name: VolumeName =
      zio.aws.fsx.model.primitives.VolumeName(impl.name())
    override val ontapConfiguration
        : Optional[zio.aws.fsx.model.CreateOntapVolumeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ontapConfiguration())
        .map(value =>
          zio.aws.fsx.model.CreateOntapVolumeConfiguration.wrap(value)
        )
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
    override val openZFSConfiguration: Optional[
      zio.aws.fsx.model.CreateOpenZFSVolumeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.openZFSConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateOpenZFSVolumeConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateVolumeRequest
  ): zio.aws.fsx.model.CreateVolumeRequest.ReadOnly = new Wrapper(impl)
}
