package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  DeleteDataInFileSystem,
  ClientRequestToken,
  DataRepositoryAssociationId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDataRepositoryAssociationRequest(
    associationId: DataRepositoryAssociationId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    deleteDataInFileSystem: Optional[DeleteDataInFileSystem] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest = {
    import DeleteDataRepositoryAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest
      .builder()
      .associationId(
        DataRepositoryAssociationId.unwrap(associationId): java.lang.String
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        deleteDataInFileSystem.map(value =>
          DeleteDataInFileSystem.unwrap(value): java.lang.Boolean
        )
      )(_.deleteDataInFileSystem)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DeleteDataRepositoryAssociationRequest.ReadOnly =
    zio.aws.fsx.model.DeleteDataRepositoryAssociationRequest
      .wrap(buildAwsValue())
}
object DeleteDataRepositoryAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteDataRepositoryAssociationRequest =
      zio.aws.fsx.model.DeleteDataRepositoryAssociationRequest(
        associationId,
        clientRequestToken.map(value => value),
        deleteDataInFileSystem.map(value => value)
      )
    def associationId: DataRepositoryAssociationId
    def clientRequestToken: Optional[ClientRequestToken]
    def deleteDataInFileSystem: Optional[DeleteDataInFileSystem]
    def getAssociationId: ZIO[Any, Nothing, DataRepositoryAssociationId] =
      ZIO.succeed(associationId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getDeleteDataInFileSystem: ZIO[Any, AwsError, DeleteDataInFileSystem] =
      AwsError.unwrapOptionField(
        "deleteDataInFileSystem",
        deleteDataInFileSystem
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest
  ) extends zio.aws.fsx.model.DeleteDataRepositoryAssociationRequest.ReadOnly {
    override val associationId: DataRepositoryAssociationId =
      zio.aws.fsx.model.primitives
        .DataRepositoryAssociationId(impl.associationId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val deleteDataInFileSystem: Optional[DeleteDataInFileSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteDataInFileSystem())
        .map(value =>
          zio.aws.fsx.model.primitives.DeleteDataInFileSystem(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteDataRepositoryAssociationRequest
  ): zio.aws.fsx.model.DeleteDataRepositoryAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
