package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.FileCacheId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteFileCacheResponse(
    fileCacheId: Optional[FileCacheId] = Optional.Absent,
    lifecycle: Optional[zio.aws.fsx.model.FileCacheLifecycle] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteFileCacheResponse = {
    import DeleteFileCacheResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteFileCacheResponse
      .builder()
      .optionallyWith(
        fileCacheId.map(value => FileCacheId.unwrap(value): java.lang.String)
      )(_.fileCacheId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteFileCacheResponse.ReadOnly =
    zio.aws.fsx.model.DeleteFileCacheResponse.wrap(buildAwsValue())
}
object DeleteFileCacheResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteFileCacheResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteFileCacheResponse =
      zio.aws.fsx.model.DeleteFileCacheResponse(
        fileCacheId.map(value => value),
        lifecycle.map(value => value)
      )
    def fileCacheId: Optional[FileCacheId]
    def lifecycle: Optional[zio.aws.fsx.model.FileCacheLifecycle]
    def getFileCacheId: ZIO[Any, AwsError, FileCacheId] =
      AwsError.unwrapOptionField("fileCacheId", fileCacheId)
    def getLifecycle: ZIO[Any, AwsError, zio.aws.fsx.model.FileCacheLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileCacheResponse
  ) extends zio.aws.fsx.model.DeleteFileCacheResponse.ReadOnly {
    override val fileCacheId: Optional[FileCacheId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileCacheId())
      .map(value => zio.aws.fsx.model.primitives.FileCacheId(value))
    override val lifecycle: Optional[zio.aws.fsx.model.FileCacheLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.fsx.model.FileCacheLifecycle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileCacheResponse
  ): zio.aws.fsx.model.DeleteFileCacheResponse.ReadOnly = new Wrapper(impl)
}
