package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDataRepositoryAssociationsResponse(
    associations: Optional[
      Iterable[zio.aws.fsx.model.DataRepositoryAssociation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse = {
    import DescribeDataRepositoryAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse.ReadOnly =
    zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeDataRepositoryAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse =
      zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse(
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def associations
        : Optional[List[zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse
  ) extends zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse.ReadOnly {
    override val associations
        : Optional[List[zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.DataRepositoryAssociation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeDataRepositoryAssociationsResponse
  ): zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
