package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{NextToken, MaxResults, FileCacheId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeFileCachesRequest(
    fileCacheIds: Optional[Iterable[FileCacheId]] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeFileCachesRequest = {
    import DescribeFileCachesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeFileCachesRequest
      .builder()
      .optionallyWith(
        fileCacheIds.map(value =>
          value.map { item =>
            FileCacheId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.fileCacheIds)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeFileCachesRequest.ReadOnly =
    zio.aws.fsx.model.DescribeFileCachesRequest.wrap(buildAwsValue())
}
object DescribeFileCachesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeFileCachesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeFileCachesRequest =
      zio.aws.fsx.model.DescribeFileCachesRequest(
        fileCacheIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def fileCacheIds: Optional[List[FileCacheId]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getFileCacheIds: ZIO[Any, AwsError, List[FileCacheId]] =
      AwsError.unwrapOptionField("fileCacheIds", fileCacheIds)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileCachesRequest
  ) extends zio.aws.fsx.model.DescribeFileCachesRequest.ReadOnly {
    override val fileCacheIds: Optional[List[FileCacheId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileCacheIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.FileCacheId(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileCachesRequest
  ): zio.aws.fsx.model.DescribeFileCachesRequest.ReadOnly = new Wrapper(impl)
}
