package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeFileCachesResponse(
    fileCaches: Optional[Iterable[zio.aws.fsx.model.FileCache]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeFileCachesResponse = {
    import DescribeFileCachesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeFileCachesResponse
      .builder()
      .optionallyWith(
        fileCaches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fileCaches)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeFileCachesResponse.ReadOnly =
    zio.aws.fsx.model.DescribeFileCachesResponse.wrap(buildAwsValue())
}
object DescribeFileCachesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeFileCachesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeFileCachesResponse =
      zio.aws.fsx.model.DescribeFileCachesResponse(
        fileCaches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fileCaches: Optional[List[zio.aws.fsx.model.FileCache.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getFileCaches
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.FileCache.ReadOnly]] =
      AwsError.unwrapOptionField("fileCaches", fileCaches)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileCachesResponse
  ) extends zio.aws.fsx.model.DescribeFileCachesResponse.ReadOnly {
    override val fileCaches
        : Optional[List[zio.aws.fsx.model.FileCache.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileCaches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.FileCache.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeFileCachesResponse
  ): zio.aws.fsx.model.DescribeFileCachesResponse.ReadOnly = new Wrapper(impl)
}
