package zio.aws.fsx.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  SubnetId,
  VpcId,
  CreationTime,
  DNSName,
  NetworkInterfaceId,
  FileSystemTypeVersion,
  FileCacheId,
  StorageCapacity,
  AWSAccountId,
  ResourceARN,
  KmsKeyId,
  DataRepositoryAssociationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class FileCache(
    ownerId: Optional[AWSAccountId] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    fileCacheId: Optional[FileCacheId] = Optional.Absent,
    fileCacheType: Optional[zio.aws.fsx.model.FileCacheType] = Optional.Absent,
    fileCacheTypeVersion: Optional[FileSystemTypeVersion] = Optional.Absent,
    lifecycle: Optional[zio.aws.fsx.model.FileCacheLifecycle] = Optional.Absent,
    failureDetails: Optional[zio.aws.fsx.model.FileCacheFailureDetails] =
      Optional.Absent,
    storageCapacity: Optional[StorageCapacity] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    networkInterfaceIds: Optional[Iterable[NetworkInterfaceId]] =
      Optional.Absent,
    dnsName: Optional[DNSName] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    resourceARN: Optional[ResourceARN] = Optional.Absent,
    lustreConfiguration: Optional[
      zio.aws.fsx.model.FileCacheLustreConfiguration
    ] = Optional.Absent,
    dataRepositoryAssociationIds: Optional[
      Iterable[DataRepositoryAssociationId]
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.fsx.model.FileCache = {
    import FileCache.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.FileCache
      .builder()
      .optionallyWith(
        ownerId.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        fileCacheId.map(value => FileCacheId.unwrap(value): java.lang.String)
      )(_.fileCacheId)
      .optionallyWith(fileCacheType.map(value => value.unwrap))(_.fileCacheType)
      .optionallyWith(
        fileCacheTypeVersion.map(value =>
          FileSystemTypeVersion.unwrap(value): java.lang.String
        )
      )(_.fileCacheTypeVersion)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .optionallyWith(
        storageCapacity.map(value => StorageCapacity.unwrap(value): Integer)
      )(_.storageCapacity)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        networkInterfaceIds.map(value =>
          value.map { item =>
            NetworkInterfaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfaceIds)
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(lustreConfiguration.map(value => value.buildAwsValue()))(
        _.lustreConfiguration
      )
      .optionallyWith(
        dataRepositoryAssociationIds.map(value =>
          value.map { item =>
            DataRepositoryAssociationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dataRepositoryAssociationIds)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.FileCache.ReadOnly =
    zio.aws.fsx.model.FileCache.wrap(buildAwsValue())
}
object FileCache {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.FileCache] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.FileCache = zio.aws.fsx.model.FileCache(
      ownerId.map(value => value),
      creationTime.map(value => value),
      fileCacheId.map(value => value),
      fileCacheType.map(value => value),
      fileCacheTypeVersion.map(value => value),
      lifecycle.map(value => value),
      failureDetails.map(value => value.asEditable),
      storageCapacity.map(value => value),
      vpcId.map(value => value),
      subnetIds.map(value => value),
      networkInterfaceIds.map(value => value),
      dnsName.map(value => value),
      kmsKeyId.map(value => value),
      resourceARN.map(value => value),
      lustreConfiguration.map(value => value.asEditable),
      dataRepositoryAssociationIds.map(value => value)
    )
    def ownerId: Optional[AWSAccountId]
    def creationTime: Optional[CreationTime]
    def fileCacheId: Optional[FileCacheId]
    def fileCacheType: Optional[zio.aws.fsx.model.FileCacheType]
    def fileCacheTypeVersion: Optional[FileSystemTypeVersion]
    def lifecycle: Optional[zio.aws.fsx.model.FileCacheLifecycle]
    def failureDetails
        : Optional[zio.aws.fsx.model.FileCacheFailureDetails.ReadOnly]
    def storageCapacity: Optional[StorageCapacity]
    def vpcId: Optional[VpcId]
    def subnetIds: Optional[List[SubnetId]]
    def networkInterfaceIds: Optional[List[NetworkInterfaceId]]
    def dnsName: Optional[DNSName]
    def kmsKeyId: Optional[KmsKeyId]
    def resourceARN: Optional[ResourceARN]
    def lustreConfiguration
        : Optional[zio.aws.fsx.model.FileCacheLustreConfiguration.ReadOnly]
    def dataRepositoryAssociationIds
        : Optional[List[DataRepositoryAssociationId]]
    def getOwnerId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFileCacheId: ZIO[Any, AwsError, FileCacheId] =
      AwsError.unwrapOptionField("fileCacheId", fileCacheId)
    def getFileCacheType: ZIO[Any, AwsError, zio.aws.fsx.model.FileCacheType] =
      AwsError.unwrapOptionField("fileCacheType", fileCacheType)
    def getFileCacheTypeVersion: ZIO[Any, AwsError, FileSystemTypeVersion] =
      AwsError.unwrapOptionField("fileCacheTypeVersion", fileCacheTypeVersion)
    def getLifecycle: ZIO[Any, AwsError, zio.aws.fsx.model.FileCacheLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getFailureDetails: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.FileCacheFailureDetails.ReadOnly
    ] = AwsError.unwrapOptionField("failureDetails", failureDetails)
    def getStorageCapacity: ZIO[Any, AwsError, StorageCapacity] =
      AwsError.unwrapOptionField("storageCapacity", storageCapacity)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getNetworkInterfaceIds: ZIO[Any, AwsError, List[NetworkInterfaceId]] =
      AwsError.unwrapOptionField("networkInterfaceIds", networkInterfaceIds)
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getLustreConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.FileCacheLustreConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("lustreConfiguration", lustreConfiguration)
    def getDataRepositoryAssociationIds
        : ZIO[Any, AwsError, List[DataRepositoryAssociationId]] =
      AwsError.unwrapOptionField(
        "dataRepositoryAssociationIds",
        dataRepositoryAssociationIds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.FileCache
  ) extends zio.aws.fsx.model.FileCache.ReadOnly {
    override val ownerId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.fsx.model.primitives.AWSAccountId(value))
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.fsx.model.primitives.CreationTime(value))
    override val fileCacheId: Optional[FileCacheId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileCacheId())
      .map(value => zio.aws.fsx.model.primitives.FileCacheId(value))
    override val fileCacheType: Optional[zio.aws.fsx.model.FileCacheType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileCacheType())
        .map(value => zio.aws.fsx.model.FileCacheType.wrap(value))
    override val fileCacheTypeVersion: Optional[FileSystemTypeVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileCacheTypeVersion())
        .map(value => zio.aws.fsx.model.primitives.FileSystemTypeVersion(value))
    override val lifecycle: Optional[zio.aws.fsx.model.FileCacheLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.fsx.model.FileCacheLifecycle.wrap(value))
    override val failureDetails
        : Optional[zio.aws.fsx.model.FileCacheFailureDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureDetails())
        .map(value => zio.aws.fsx.model.FileCacheFailureDetails.wrap(value))
    override val storageCapacity: Optional[StorageCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageCapacity())
        .map(value => zio.aws.fsx.model.primitives.StorageCapacity(value))
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.fsx.model.primitives.VpcId(value))
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.SubnetId(item)
        }.toList
      )
    override val networkInterfaceIds: Optional[List[NetworkInterfaceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.NetworkInterfaceId(item)
          }.toList
        )
    override val dnsName: Optional[DNSName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.fsx.model.primitives.DNSName(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.fsx.model.primitives.KmsKeyId(value))
    override val resourceARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
    override val lustreConfiguration
        : Optional[zio.aws.fsx.model.FileCacheLustreConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lustreConfiguration())
        .map(value =>
          zio.aws.fsx.model.FileCacheLustreConfiguration.wrap(value)
        )
    override val dataRepositoryAssociationIds
        : Optional[List[DataRepositoryAssociationId]] = zio.aws.core.internal
      .optionalFromNullable(impl.dataRepositoryAssociationIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.DataRepositoryAssociationId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.FileCache
  ): zio.aws.fsx.model.FileCache.ReadOnly = new Wrapper(impl)
}
