package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{ArchivePath, Namespace}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FileCacheDataRepositoryAssociation(
    fileCachePath: Namespace,
    dataRepositoryPath: ArchivePath,
    dataRepositorySubdirectories: Optional[Iterable[Namespace]] =
      Optional.Absent,
    nfs: Optional[zio.aws.fsx.model.FileCacheNFSConfiguration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.FileCacheDataRepositoryAssociation = {
    import FileCacheDataRepositoryAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.FileCacheDataRepositoryAssociation
      .builder()
      .fileCachePath(Namespace.unwrap(fileCachePath): java.lang.String)
      .dataRepositoryPath(
        ArchivePath.unwrap(dataRepositoryPath): java.lang.String
      )
      .optionallyWith(
        dataRepositorySubdirectories.map(value =>
          value.map { item =>
            Namespace.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dataRepositorySubdirectories)
      .optionallyWith(nfs.map(value => value.buildAwsValue()))(_.nfs)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.FileCacheDataRepositoryAssociation.ReadOnly =
    zio.aws.fsx.model.FileCacheDataRepositoryAssociation.wrap(buildAwsValue())
}
object FileCacheDataRepositoryAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.FileCacheDataRepositoryAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.FileCacheDataRepositoryAssociation =
      zio.aws.fsx.model.FileCacheDataRepositoryAssociation(
        fileCachePath,
        dataRepositoryPath,
        dataRepositorySubdirectories.map(value => value),
        nfs.map(value => value.asEditable)
      )
    def fileCachePath: Namespace
    def dataRepositoryPath: ArchivePath
    def dataRepositorySubdirectories: Optional[List[Namespace]]
    def nfs: Optional[zio.aws.fsx.model.FileCacheNFSConfiguration.ReadOnly]
    def getFileCachePath: ZIO[Any, Nothing, Namespace] =
      ZIO.succeed(fileCachePath)
    def getDataRepositoryPath: ZIO[Any, Nothing, ArchivePath] =
      ZIO.succeed(dataRepositoryPath)
    def getDataRepositorySubdirectories: ZIO[Any, AwsError, List[Namespace]] =
      AwsError.unwrapOptionField(
        "dataRepositorySubdirectories",
        dataRepositorySubdirectories
      )
    def getNfs: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.FileCacheNFSConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("nfs", nfs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.FileCacheDataRepositoryAssociation
  ) extends zio.aws.fsx.model.FileCacheDataRepositoryAssociation.ReadOnly {
    override val fileCachePath: Namespace =
      zio.aws.fsx.model.primitives.Namespace(impl.fileCachePath())
    override val dataRepositoryPath: ArchivePath =
      zio.aws.fsx.model.primitives.ArchivePath(impl.dataRepositoryPath())
    override val dataRepositorySubdirectories: Optional[List[Namespace]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataRepositorySubdirectories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.Namespace(item)
          }.toList
        )
    override val nfs
        : Optional[zio.aws.fsx.model.FileCacheNFSConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nfs())
        .map(value => zio.aws.fsx.model.FileCacheNFSConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.FileCacheDataRepositoryAssociation
  ): zio.aws.fsx.model.FileCacheDataRepositoryAssociation.ReadOnly =
    new Wrapper(impl)
}
