package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.FilterValue
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Filter(
    name: Optional[zio.aws.fsx.model.FilterName] = Optional.Absent,
    values: Optional[Iterable[FilterValue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.fsx.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.Filter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            FilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.Filter.ReadOnly =
    zio.aws.fsx.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.Filter = zio.aws.fsx.model
      .Filter(name.map(value => value), values.map(value => value))
    def name: Optional[zio.aws.fsx.model.FilterName]
    def values: Optional[List[FilterValue]]
    def getName: ZIO[Any, AwsError, zio.aws.fsx.model.FilterName] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[FilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.Filter
  ) extends zio.aws.fsx.model.Filter.ReadOnly {
    override val name: Optional[zio.aws.fsx.model.FilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.fsx.model.FilterName.wrap(value))
    override val values: Optional[List[FilterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.FilterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.Filter
  ): zio.aws.fsx.model.Filter.ReadOnly = new Wrapper(impl)
}
