package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait InputOntapVolumeType {
  def unwrap: software.amazon.awssdk.services.fsx.model.InputOntapVolumeType
}
object InputOntapVolumeType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.InputOntapVolumeType
  ): zio.aws.fsx.model.InputOntapVolumeType = value match {
    case software.amazon.awssdk.services.fsx.model.InputOntapVolumeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.InputOntapVolumeType.RW =>
      val r = RW
      r
    case software.amazon.awssdk.services.fsx.model.InputOntapVolumeType.DP =>
      val r = DP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.InputOntapVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.InputOntapVolumeType =
      software.amazon.awssdk.services.fsx.model.InputOntapVolumeType.UNKNOWN_TO_SDK_VERSION
  }
  case object RW extends zio.aws.fsx.model.InputOntapVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.InputOntapVolumeType =
      software.amazon.awssdk.services.fsx.model.InputOntapVolumeType.RW
  }
  case object DP extends zio.aws.fsx.model.InputOntapVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.InputOntapVolumeType =
      software.amazon.awssdk.services.fsx.model.InputOntapVolumeType.DP
  }
}
