package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  DailyTime,
  AutomaticBackupRetentionDays,
  PerUnitStorageThroughput,
  LustreFileSystemMountName,
  WeeklyTime,
  Flag
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class LustreFileSystemConfiguration(
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent,
    dataRepositoryConfiguration: Optional[
      zio.aws.fsx.model.DataRepositoryConfiguration
    ] = Optional.Absent,
    deploymentType: Optional[zio.aws.fsx.model.LustreDeploymentType] =
      Optional.Absent,
    perUnitStorageThroughput: Optional[PerUnitStorageThroughput] =
      Optional.Absent,
    mountName: Optional[LustreFileSystemMountName] = Optional.Absent,
    dailyAutomaticBackupStartTime: Optional[DailyTime] = Optional.Absent,
    automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays] =
      Optional.Absent,
    copyTagsToBackups: Optional[Flag] = Optional.Absent,
    driveCacheType: Optional[zio.aws.fsx.model.DriveCacheType] =
      Optional.Absent,
    dataCompressionType: Optional[zio.aws.fsx.model.DataCompressionType] =
      Optional.Absent,
    logConfiguration: Optional[zio.aws.fsx.model.LustreLogConfiguration] =
      Optional.Absent,
    rootSquashConfiguration: Optional[
      zio.aws.fsx.model.LustreRootSquashConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.LustreFileSystemConfiguration = {
    import LustreFileSystemConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.LustreFileSystemConfiguration
      .builder()
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        dataRepositoryConfiguration.map(value => value.buildAwsValue())
      )(_.dataRepositoryConfiguration)
      .optionallyWith(deploymentType.map(value => value.unwrap))(
        _.deploymentType
      )
      .optionallyWith(
        perUnitStorageThroughput.map(value =>
          PerUnitStorageThroughput.unwrap(value): Integer
        )
      )(_.perUnitStorageThroughput)
      .optionallyWith(
        mountName.map(value =>
          LustreFileSystemMountName.unwrap(value): java.lang.String
        )
      )(_.mountName)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .optionallyWith(driveCacheType.map(value => value.unwrap))(
        _.driveCacheType
      )
      .optionallyWith(dataCompressionType.map(value => value.unwrap))(
        _.dataCompressionType
      )
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .optionallyWith(
        rootSquashConfiguration.map(value => value.buildAwsValue())
      )(_.rootSquashConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.LustreFileSystemConfiguration.ReadOnly =
    zio.aws.fsx.model.LustreFileSystemConfiguration.wrap(buildAwsValue())
}
object LustreFileSystemConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.LustreFileSystemConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.LustreFileSystemConfiguration =
      zio.aws.fsx.model.LustreFileSystemConfiguration(
        weeklyMaintenanceStartTime.map(value => value),
        dataRepositoryConfiguration.map(value => value.asEditable),
        deploymentType.map(value => value),
        perUnitStorageThroughput.map(value => value),
        mountName.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        automaticBackupRetentionDays.map(value => value),
        copyTagsToBackups.map(value => value),
        driveCacheType.map(value => value),
        dataCompressionType.map(value => value),
        logConfiguration.map(value => value.asEditable),
        rootSquashConfiguration.map(value => value.asEditable)
      )
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def dataRepositoryConfiguration
        : Optional[zio.aws.fsx.model.DataRepositoryConfiguration.ReadOnly]
    def deploymentType: Optional[zio.aws.fsx.model.LustreDeploymentType]
    def perUnitStorageThroughput: Optional[PerUnitStorageThroughput]
    def mountName: Optional[LustreFileSystemMountName]
    def dailyAutomaticBackupStartTime: Optional[DailyTime]
    def automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays]
    def copyTagsToBackups: Optional[Flag]
    def driveCacheType: Optional[zio.aws.fsx.model.DriveCacheType]
    def dataCompressionType: Optional[zio.aws.fsx.model.DataCompressionType]
    def logConfiguration
        : Optional[zio.aws.fsx.model.LustreLogConfiguration.ReadOnly]
    def rootSquashConfiguration
        : Optional[zio.aws.fsx.model.LustreRootSquashConfiguration.ReadOnly]
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDataRepositoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DataRepositoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataRepositoryConfiguration",
      dataRepositoryConfiguration
    )
    def getDeploymentType
        : ZIO[Any, AwsError, zio.aws.fsx.model.LustreDeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getPerUnitStorageThroughput
        : ZIO[Any, AwsError, PerUnitStorageThroughput] = AwsError
      .unwrapOptionField("perUnitStorageThroughput", perUnitStorageThroughput)
    def getMountName: ZIO[Any, AwsError, LustreFileSystemMountName] =
      AwsError.unwrapOptionField("mountName", mountName)
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
    def getDriveCacheType
        : ZIO[Any, AwsError, zio.aws.fsx.model.DriveCacheType] =
      AwsError.unwrapOptionField("driveCacheType", driveCacheType)
    def getDataCompressionType
        : ZIO[Any, AwsError, zio.aws.fsx.model.DataCompressionType] =
      AwsError.unwrapOptionField("dataCompressionType", dataCompressionType)
    def getLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LustreLogConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("logConfiguration", logConfiguration)
    def getRootSquashConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LustreRootSquashConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rootSquashConfiguration",
      rootSquashConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.LustreFileSystemConfiguration
  ) extends zio.aws.fsx.model.LustreFileSystemConfiguration.ReadOnly {
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val dataRepositoryConfiguration
        : Optional[zio.aws.fsx.model.DataRepositoryConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataRepositoryConfiguration())
        .map(value => zio.aws.fsx.model.DataRepositoryConfiguration.wrap(value))
    override val deploymentType
        : Optional[zio.aws.fsx.model.LustreDeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentType())
        .map(value => zio.aws.fsx.model.LustreDeploymentType.wrap(value))
    override val perUnitStorageThroughput: Optional[PerUnitStorageThroughput] =
      zio.aws.core.internal
        .optionalFromNullable(impl.perUnitStorageThroughput())
        .map(value =>
          zio.aws.fsx.model.primitives.PerUnitStorageThroughput(value)
        )
    override val mountName: Optional[LustreFileSystemMountName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountName())
        .map(value =>
          zio.aws.fsx.model.primitives.LustreFileSystemMountName(value)
        )
    override val dailyAutomaticBackupStartTime: Optional[DailyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dailyAutomaticBackupStartTime())
        .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val automaticBackupRetentionDays
        : Optional[AutomaticBackupRetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val copyTagsToBackups: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val driveCacheType: Optional[zio.aws.fsx.model.DriveCacheType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.driveCacheType())
        .map(value => zio.aws.fsx.model.DriveCacheType.wrap(value))
    override val dataCompressionType
        : Optional[zio.aws.fsx.model.DataCompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCompressionType())
        .map(value => zio.aws.fsx.model.DataCompressionType.wrap(value))
    override val logConfiguration
        : Optional[zio.aws.fsx.model.LustreLogConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logConfiguration())
        .map(value => zio.aws.fsx.model.LustreLogConfiguration.wrap(value))
    override val rootSquashConfiguration
        : Optional[zio.aws.fsx.model.LustreRootSquashConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootSquashConfiguration())
        .map(value =>
          zio.aws.fsx.model.LustreRootSquashConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.LustreFileSystemConfiguration
  ): zio.aws.fsx.model.LustreFileSystemConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
