package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait NfsVersion {
  def unwrap: software.amazon.awssdk.services.fsx.model.NfsVersion
}
object NfsVersion {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.NfsVersion
  ): zio.aws.fsx.model.NfsVersion = value match {
    case software.amazon.awssdk.services.fsx.model.NfsVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.NfsVersion.NFS3 =>
      val r = NFS3
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.NfsVersion {
    override def unwrap: software.amazon.awssdk.services.fsx.model.NfsVersion =
      software.amazon.awssdk.services.fsx.model.NfsVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object NFS3 extends zio.aws.fsx.model.NfsVersion {
    override def unwrap: software.amazon.awssdk.services.fsx.model.NfsVersion =
      software.amazon.awssdk.services.fsx.model.NfsVersion.NFS3
  }
}
