package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  DailyTime,
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  WeeklyTime,
  Flag,
  VolumeId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class OpenZFSFileSystemConfiguration(
    automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays] =
      Optional.Absent,
    copyTagsToBackups: Optional[Flag] = Optional.Absent,
    copyTagsToVolumes: Optional[Flag] = Optional.Absent,
    dailyAutomaticBackupStartTime: Optional[DailyTime] = Optional.Absent,
    deploymentType: Optional[zio.aws.fsx.model.OpenZFSDeploymentType] =
      Optional.Absent,
    throughputCapacity: Optional[MegabytesPerSecond] = Optional.Absent,
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent,
    diskIopsConfiguration: Optional[zio.aws.fsx.model.DiskIopsConfiguration] =
      Optional.Absent,
    rootVolumeId: Optional[VolumeId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.OpenZFSFileSystemConfiguration = {
    import OpenZFSFileSystemConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.OpenZFSFileSystemConfiguration
      .builder()
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .optionallyWith(
        copyTagsToVolumes.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToVolumes)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(deploymentType.map(value => value.unwrap))(
        _.deploymentType
      )
      .optionallyWith(
        throughputCapacity.map(value =>
          MegabytesPerSecond.unwrap(value): Integer
        )
      )(_.throughputCapacity)
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        diskIopsConfiguration.map(value => value.buildAwsValue())
      )(_.diskIopsConfiguration)
      .optionallyWith(
        rootVolumeId.map(value => VolumeId.unwrap(value): java.lang.String)
      )(_.rootVolumeId)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.OpenZFSFileSystemConfiguration.ReadOnly =
    zio.aws.fsx.model.OpenZFSFileSystemConfiguration.wrap(buildAwsValue())
}
object OpenZFSFileSystemConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.OpenZFSFileSystemConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.OpenZFSFileSystemConfiguration =
      zio.aws.fsx.model.OpenZFSFileSystemConfiguration(
        automaticBackupRetentionDays.map(value => value),
        copyTagsToBackups.map(value => value),
        copyTagsToVolumes.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        deploymentType.map(value => value),
        throughputCapacity.map(value => value),
        weeklyMaintenanceStartTime.map(value => value),
        diskIopsConfiguration.map(value => value.asEditable),
        rootVolumeId.map(value => value)
      )
    def automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays]
    def copyTagsToBackups: Optional[Flag]
    def copyTagsToVolumes: Optional[Flag]
    def dailyAutomaticBackupStartTime: Optional[DailyTime]
    def deploymentType: Optional[zio.aws.fsx.model.OpenZFSDeploymentType]
    def throughputCapacity: Optional[MegabytesPerSecond]
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def diskIopsConfiguration
        : Optional[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly]
    def rootVolumeId: Optional[VolumeId]
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
    def getCopyTagsToVolumes: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToVolumes", copyTagsToVolumes)
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getDeploymentType
        : ZIO[Any, AwsError, zio.aws.fsx.model.OpenZFSDeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getThroughputCapacity: ZIO[Any, AwsError, MegabytesPerSecond] =
      AwsError.unwrapOptionField("throughputCapacity", throughputCapacity)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDiskIopsConfiguration
        : ZIO[Any, AwsError, zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("diskIopsConfiguration", diskIopsConfiguration)
    def getRootVolumeId: ZIO[Any, AwsError, VolumeId] =
      AwsError.unwrapOptionField("rootVolumeId", rootVolumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSFileSystemConfiguration
  ) extends zio.aws.fsx.model.OpenZFSFileSystemConfiguration.ReadOnly {
    override val automaticBackupRetentionDays
        : Optional[AutomaticBackupRetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val copyTagsToBackups: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val copyTagsToVolumes: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToVolumes())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val dailyAutomaticBackupStartTime: Optional[DailyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dailyAutomaticBackupStartTime())
        .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val deploymentType
        : Optional[zio.aws.fsx.model.OpenZFSDeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentType())
        .map(value => zio.aws.fsx.model.OpenZFSDeploymentType.wrap(value))
    override val throughputCapacity: Optional[MegabytesPerSecond] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputCapacity())
        .map(value => zio.aws.fsx.model.primitives.MegabytesPerSecond(value))
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val diskIopsConfiguration
        : Optional[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskIopsConfiguration())
        .map(value => zio.aws.fsx.model.DiskIopsConfiguration.wrap(value))
    override val rootVolumeId: Optional[VolumeId] = zio.aws.core.internal
      .optionalFromNullable(impl.rootVolumeId())
      .map(value => zio.aws.fsx.model.primitives.VolumeId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSFileSystemConfiguration
  ): zio.aws.fsx.model.OpenZFSFileSystemConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
