package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.fsx.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.ResourceType
  ): zio.aws.fsx.model.ResourceType = value match {
    case software.amazon.awssdk.services.fsx.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.ResourceType.FILE_SYSTEM =>
      val r = FILE_SYSTEM
      r
    case software.amazon.awssdk.services.fsx.model.ResourceType.VOLUME =>
      val r = VOLUME
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.ResourceType =
      software.amazon.awssdk.services.fsx.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object FILE_SYSTEM extends zio.aws.fsx.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.ResourceType =
      software.amazon.awssdk.services.fsx.model.ResourceType.FILE_SYSTEM
  }
  case object VOLUME extends zio.aws.fsx.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.ResourceType =
      software.amazon.awssdk.services.fsx.model.ResourceType.VOLUME
  }
}
