package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait StorageType {
  def unwrap: software.amazon.awssdk.services.fsx.model.StorageType
}
object StorageType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.StorageType
  ): zio.aws.fsx.model.StorageType = value match {
    case software.amazon.awssdk.services.fsx.model.StorageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.StorageType.SSD =>
      val r = SSD
      r
    case software.amazon.awssdk.services.fsx.model.StorageType.HDD =>
      val r = HDD
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.StorageType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.StorageType =
      software.amazon.awssdk.services.fsx.model.StorageType.UNKNOWN_TO_SDK_VERSION
  }
  case object SSD extends zio.aws.fsx.model.StorageType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.StorageType =
      software.amazon.awssdk.services.fsx.model.StorageType.SSD
  }
  case object HDD extends zio.aws.fsx.model.StorageType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.StorageType =
      software.amazon.awssdk.services.fsx.model.StorageType.HDD
  }
}
