package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  DailyTime,
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  RouteTableId,
  WeeklyTime,
  AdminPassword
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateFileSystemOntapConfiguration(
    automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays] =
      Optional.Absent,
    dailyAutomaticBackupStartTime: Optional[DailyTime] = Optional.Absent,
    fsxAdminPassword: Optional[AdminPassword] = Optional.Absent,
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent,
    diskIopsConfiguration: Optional[zio.aws.fsx.model.DiskIopsConfiguration] =
      Optional.Absent,
    throughputCapacity: Optional[MegabytesPerSecond] = Optional.Absent,
    addRouteTableIds: Optional[Iterable[RouteTableId]] = Optional.Absent,
    removeRouteTableIds: Optional[Iterable[RouteTableId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateFileSystemOntapConfiguration = {
    import UpdateFileSystemOntapConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemOntapConfiguration
      .builder()
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        fsxAdminPassword.map(value =>
          AdminPassword.unwrap(value): java.lang.String
        )
      )(_.fsxAdminPassword)
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        diskIopsConfiguration.map(value => value.buildAwsValue())
      )(_.diskIopsConfiguration)
      .optionallyWith(
        throughputCapacity.map(value =>
          MegabytesPerSecond.unwrap(value): Integer
        )
      )(_.throughputCapacity)
      .optionallyWith(
        addRouteTableIds.map(value =>
          value.map { item =>
            RouteTableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addRouteTableIds)
      .optionallyWith(
        removeRouteTableIds.map(value =>
          value.map { item =>
            RouteTableId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeRouteTableIds)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateFileSystemOntapConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateFileSystemOntapConfiguration.wrap(buildAwsValue())
}
object UpdateFileSystemOntapConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemOntapConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateFileSystemOntapConfiguration =
      zio.aws.fsx.model.UpdateFileSystemOntapConfiguration(
        automaticBackupRetentionDays.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        fsxAdminPassword.map(value => value),
        weeklyMaintenanceStartTime.map(value => value),
        diskIopsConfiguration.map(value => value.asEditable),
        throughputCapacity.map(value => value),
        addRouteTableIds.map(value => value),
        removeRouteTableIds.map(value => value)
      )
    def automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays]
    def dailyAutomaticBackupStartTime: Optional[DailyTime]
    def fsxAdminPassword: Optional[AdminPassword]
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def diskIopsConfiguration
        : Optional[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly]
    def throughputCapacity: Optional[MegabytesPerSecond]
    def addRouteTableIds: Optional[List[RouteTableId]]
    def removeRouteTableIds: Optional[List[RouteTableId]]
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getFsxAdminPassword: ZIO[Any, AwsError, AdminPassword] =
      AwsError.unwrapOptionField("fsxAdminPassword", fsxAdminPassword)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDiskIopsConfiguration
        : ZIO[Any, AwsError, zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("diskIopsConfiguration", diskIopsConfiguration)
    def getThroughputCapacity: ZIO[Any, AwsError, MegabytesPerSecond] =
      AwsError.unwrapOptionField("throughputCapacity", throughputCapacity)
    def getAddRouteTableIds: ZIO[Any, AwsError, List[RouteTableId]] =
      AwsError.unwrapOptionField("addRouteTableIds", addRouteTableIds)
    def getRemoveRouteTableIds: ZIO[Any, AwsError, List[RouteTableId]] =
      AwsError.unwrapOptionField("removeRouteTableIds", removeRouteTableIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemOntapConfiguration
  ) extends zio.aws.fsx.model.UpdateFileSystemOntapConfiguration.ReadOnly {
    override val automaticBackupRetentionDays
        : Optional[AutomaticBackupRetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val dailyAutomaticBackupStartTime: Optional[DailyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dailyAutomaticBackupStartTime())
        .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val fsxAdminPassword: Optional[AdminPassword] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fsxAdminPassword())
        .map(value => zio.aws.fsx.model.primitives.AdminPassword(value))
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val diskIopsConfiguration
        : Optional[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskIopsConfiguration())
        .map(value => zio.aws.fsx.model.DiskIopsConfiguration.wrap(value))
    override val throughputCapacity: Optional[MegabytesPerSecond] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputCapacity())
        .map(value => zio.aws.fsx.model.primitives.MegabytesPerSecond(value))
    override val addRouteTableIds: Optional[List[RouteTableId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addRouteTableIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.RouteTableId(item)
          }.toList
        )
    override val removeRouteTableIds: Optional[List[RouteTableId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeRouteTableIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.RouteTableId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemOntapConfiguration
  ): zio.aws.fsx.model.UpdateFileSystemOntapConfiguration.ReadOnly =
    new Wrapper(impl)
}
