package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait AliasLifecycle {
  def unwrap: software.amazon.awssdk.services.fsx.model.AliasLifecycle
}
object AliasLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.AliasLifecycle
  ): zio.aws.fsx.model.AliasLifecycle = value match {
    case software.amazon.awssdk.services.fsx.model.AliasLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.AliasLifecycle.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.fsx.model.AliasLifecycle.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.fsx.model.AliasLifecycle.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.fsx.model.AliasLifecycle.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.fsx.model.AliasLifecycle.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.AliasLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AliasLifecycle =
      software.amazon.awssdk.services.fsx.model.AliasLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.fsx.model.AliasLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AliasLifecycle =
      software.amazon.awssdk.services.fsx.model.AliasLifecycle.AVAILABLE
  }
  case object CREATING extends zio.aws.fsx.model.AliasLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AliasLifecycle =
      software.amazon.awssdk.services.fsx.model.AliasLifecycle.CREATING
  }
  case object DELETING extends zio.aws.fsx.model.AliasLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AliasLifecycle =
      software.amazon.awssdk.services.fsx.model.AliasLifecycle.DELETING
  }
  case object CREATE_FAILED extends zio.aws.fsx.model.AliasLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AliasLifecycle =
      software.amazon.awssdk.services.fsx.model.AliasLifecycle.CREATE_FAILED
  }
  case object DELETE_FAILED extends zio.aws.fsx.model.AliasLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AliasLifecycle =
      software.amazon.awssdk.services.fsx.model.AliasLifecycle.DELETE_FAILED
  }
}
