package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.fsx.model.primitives.TaskId
import scala.jdk.CollectionConverters.*
final case class CancelDataRepositoryTaskRequest(taskId: TaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskRequest = {
    import CancelDataRepositoryTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskRequest
      .builder()
      .taskId(TaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CancelDataRepositoryTaskRequest.ReadOnly =
    zio.aws.fsx.model.CancelDataRepositoryTaskRequest.wrap(buildAwsValue())
}
object CancelDataRepositoryTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CancelDataRepositoryTaskRequest =
      zio.aws.fsx.model.CancelDataRepositoryTaskRequest(taskId)
    def taskId: TaskId
    def getTaskId: ZIO[Any, Nothing, TaskId] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskRequest
  ) extends zio.aws.fsx.model.CancelDataRepositoryTaskRequest.ReadOnly {
    override val taskId: TaskId =
      zio.aws.fsx.model.primitives.TaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CancelDataRepositoryTaskRequest
  ): zio.aws.fsx.model.CancelDataRepositoryTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
