package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  BatchImportMetaDataOnCreate,
  Megabytes,
  Namespace,
  ClientRequestToken,
  FileSystemId,
  ArchivePath
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateDataRepositoryAssociationRequest(
    fileSystemId: FileSystemId,
    fileSystemPath: Optional[Namespace] = Optional.Absent,
    dataRepositoryPath: ArchivePath,
    batchImportMetaDataOnCreate: Optional[BatchImportMetaDataOnCreate] =
      Optional.Absent,
    importedFileChunkSize: Optional[Megabytes] = Optional.Absent,
    s3: Optional[zio.aws.fsx.model.S3DataRepositoryConfiguration] =
      Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest = {
    import CreateDataRepositoryAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest
      .builder()
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .optionallyWith(
        fileSystemPath.map(value => Namespace.unwrap(value): java.lang.String)
      )(_.fileSystemPath)
      .dataRepositoryPath(
        ArchivePath.unwrap(dataRepositoryPath): java.lang.String
      )
      .optionallyWith(
        batchImportMetaDataOnCreate.map(value =>
          BatchImportMetaDataOnCreate.unwrap(value): java.lang.Boolean
        )
      )(_.batchImportMetaDataOnCreate)
      .optionallyWith(
        importedFileChunkSize.map(value => Megabytes.unwrap(value): Integer)
      )(_.importedFileChunkSize)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateDataRepositoryAssociationRequest.ReadOnly =
    zio.aws.fsx.model.CreateDataRepositoryAssociationRequest
      .wrap(buildAwsValue())
}
object CreateDataRepositoryAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateDataRepositoryAssociationRequest =
      zio.aws.fsx.model.CreateDataRepositoryAssociationRequest(
        fileSystemId,
        fileSystemPath.map(value => value),
        dataRepositoryPath,
        batchImportMetaDataOnCreate.map(value => value),
        importedFileChunkSize.map(value => value),
        s3.map(value => value.asEditable),
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fileSystemId: FileSystemId
    def fileSystemPath: Optional[Namespace]
    def dataRepositoryPath: ArchivePath
    def batchImportMetaDataOnCreate: Optional[BatchImportMetaDataOnCreate]
    def importedFileChunkSize: Optional[Megabytes]
    def s3: Optional[zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly]
    def clientRequestToken: Optional[ClientRequestToken]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getFileSystemPath: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("fileSystemPath", fileSystemPath)
    def getDataRepositoryPath: ZIO[Any, Nothing, ArchivePath] =
      ZIO.succeed(dataRepositoryPath)
    def getBatchImportMetaDataOnCreate
        : ZIO[Any, AwsError, BatchImportMetaDataOnCreate] =
      AwsError.unwrapOptionField(
        "batchImportMetaDataOnCreate",
        batchImportMetaDataOnCreate
      )
    def getImportedFileChunkSize: ZIO[Any, AwsError, Megabytes] =
      AwsError.unwrapOptionField("importedFileChunkSize", importedFileChunkSize)
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest
  ) extends zio.aws.fsx.model.CreateDataRepositoryAssociationRequest.ReadOnly {
    override val fileSystemId: FileSystemId =
      zio.aws.fsx.model.primitives.FileSystemId(impl.fileSystemId())
    override val fileSystemPath: Optional[Namespace] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemPath())
      .map(value => zio.aws.fsx.model.primitives.Namespace(value))
    override val dataRepositoryPath: ArchivePath =
      zio.aws.fsx.model.primitives.ArchivePath(impl.dataRepositoryPath())
    override val batchImportMetaDataOnCreate
        : Optional[BatchImportMetaDataOnCreate] = zio.aws.core.internal
      .optionalFromNullable(impl.batchImportMetaDataOnCreate())
      .map(value =>
        zio.aws.fsx.model.primitives.BatchImportMetaDataOnCreate(value)
      )
    override val importedFileChunkSize: Optional[Megabytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedFileChunkSize())
        .map(value => zio.aws.fsx.model.primitives.Megabytes(value))
    override val s3
        : Optional[zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value =>
          zio.aws.fsx.model.S3DataRepositoryConfiguration.wrap(value)
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateDataRepositoryAssociationRequest
  ): zio.aws.fsx.model.CreateDataRepositoryAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
