package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{WeeklyTime, PerUnitStorageThroughput}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateFileCacheLustreConfiguration(
    perUnitStorageThroughput: PerUnitStorageThroughput,
    deploymentType: zio.aws.fsx.model.FileCacheLustreDeploymentType,
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent,
    metadataConfiguration: zio.aws.fsx.model.FileCacheLustreMetadataConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileCacheLustreConfiguration = {
    import CreateFileCacheLustreConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileCacheLustreConfiguration
      .builder()
      .perUnitStorageThroughput(
        PerUnitStorageThroughput.unwrap(perUnitStorageThroughput): Integer
      )
      .deploymentType(deploymentType.unwrap)
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .metadataConfiguration(metadataConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateFileCacheLustreConfiguration.ReadOnly =
    zio.aws.fsx.model.CreateFileCacheLustreConfiguration.wrap(buildAwsValue())
}
object CreateFileCacheLustreConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileCacheLustreConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileCacheLustreConfiguration =
      zio.aws.fsx.model.CreateFileCacheLustreConfiguration(
        perUnitStorageThroughput,
        deploymentType,
        weeklyMaintenanceStartTime.map(value => value),
        metadataConfiguration.asEditable
      )
    def perUnitStorageThroughput: PerUnitStorageThroughput
    def deploymentType: zio.aws.fsx.model.FileCacheLustreDeploymentType
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def metadataConfiguration
        : zio.aws.fsx.model.FileCacheLustreMetadataConfiguration.ReadOnly
    def getPerUnitStorageThroughput
        : ZIO[Any, Nothing, PerUnitStorageThroughput] =
      ZIO.succeed(perUnitStorageThroughput)
    def getDeploymentType
        : ZIO[Any, Nothing, zio.aws.fsx.model.FileCacheLustreDeploymentType] =
      ZIO.succeed(deploymentType)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getMetadataConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.fsx.model.FileCacheLustreMetadataConfiguration.ReadOnly
    ] = ZIO.succeed(metadataConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileCacheLustreConfiguration
  ) extends zio.aws.fsx.model.CreateFileCacheLustreConfiguration.ReadOnly {
    override val perUnitStorageThroughput: PerUnitStorageThroughput =
      zio.aws.fsx.model.primitives
        .PerUnitStorageThroughput(impl.perUnitStorageThroughput())
    override val deploymentType
        : zio.aws.fsx.model.FileCacheLustreDeploymentType =
      zio.aws.fsx.model.FileCacheLustreDeploymentType
        .wrap(impl.deploymentType())
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val metadataConfiguration
        : zio.aws.fsx.model.FileCacheLustreMetadataConfiguration.ReadOnly =
      zio.aws.fsx.model.FileCacheLustreMetadataConfiguration
        .wrap(impl.metadataConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileCacheLustreConfiguration
  ): zio.aws.fsx.model.CreateFileCacheLustreConfiguration.ReadOnly =
    new Wrapper(impl)
}
