package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{VolumeName, ClientRequestToken, BackupId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateVolumeFromBackupRequest(
    backupId: BackupId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    name: VolumeName,
    ontapConfiguration: Optional[
      zio.aws.fsx.model.CreateOntapVolumeConfiguration
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupRequest = {
    import CreateVolumeFromBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupRequest
      .builder()
      .backupId(BackupId.unwrap(backupId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .name(VolumeName.unwrap(name): java.lang.String)
      .optionallyWith(ontapConfiguration.map(value => value.buildAwsValue()))(
        _.ontapConfiguration
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateVolumeFromBackupRequest.ReadOnly =
    zio.aws.fsx.model.CreateVolumeFromBackupRequest.wrap(buildAwsValue())
}
object CreateVolumeFromBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateVolumeFromBackupRequest =
      zio.aws.fsx.model.CreateVolumeFromBackupRequest(
        backupId,
        clientRequestToken.map(value => value),
        name,
        ontapConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def backupId: BackupId
    def clientRequestToken: Optional[ClientRequestToken]
    def name: VolumeName
    def ontapConfiguration
        : Optional[zio.aws.fsx.model.CreateOntapVolumeConfiguration.ReadOnly]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def getBackupId: ZIO[Any, Nothing, BackupId] = ZIO.succeed(backupId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getName: ZIO[Any, Nothing, VolumeName] = ZIO.succeed(name)
    def getOntapConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateOntapVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ontapConfiguration", ontapConfiguration)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupRequest
  ) extends zio.aws.fsx.model.CreateVolumeFromBackupRequest.ReadOnly {
    override val backupId: BackupId =
      zio.aws.fsx.model.primitives.BackupId(impl.backupId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val name: VolumeName =
      zio.aws.fsx.model.primitives.VolumeName(impl.name())
    override val ontapConfiguration
        : Optional[zio.aws.fsx.model.CreateOntapVolumeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ontapConfiguration())
        .map(value =>
          zio.aws.fsx.model.CreateOntapVolumeConfiguration.wrap(value)
        )
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateVolumeFromBackupRequest
  ): zio.aws.fsx.model.CreateVolumeFromBackupRequest.ReadOnly = new Wrapper(
    impl
  )
}
