package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait DataRepositoryTaskFilterName {
  def unwrap
      : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName
}
object DataRepositoryTaskFilterName {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName
  ): zio.aws.fsx.model.DataRepositoryTaskFilterName = value match {
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName.FILE_SYSTEM_ID =>
      val r = `file-system-id`
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName.TASK_LIFECYCLE =>
      val r = `task-lifecycle`
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName.DATA_REPOSITORY_ASSOCIATION_ID =>
      val r = `data-repository-association-id`
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName.FILE_CACHE_ID =>
      val r = `file-cache-id`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.DataRepositoryTaskFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object `file-system-id`
      extends zio.aws.fsx.model.DataRepositoryTaskFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName.FILE_SYSTEM_ID
  }
  case object `task-lifecycle`
      extends zio.aws.fsx.model.DataRepositoryTaskFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName.TASK_LIFECYCLE
  }
  case object `data-repository-association-id`
      extends zio.aws.fsx.model.DataRepositoryTaskFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName.DATA_REPOSITORY_ASSOCIATION_ID
  }
  case object `file-cache-id`
      extends zio.aws.fsx.model.DataRepositoryTaskFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName =
      software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilterName.FILE_CACHE_ID
  }
}
