package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{ClientRequestToken, FileCacheId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteFileCacheRequest(
    fileCacheId: FileCacheId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteFileCacheRequest = {
    import DeleteFileCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteFileCacheRequest
      .builder()
      .fileCacheId(FileCacheId.unwrap(fileCacheId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteFileCacheRequest.ReadOnly =
    zio.aws.fsx.model.DeleteFileCacheRequest.wrap(buildAwsValue())
}
object DeleteFileCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteFileCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteFileCacheRequest =
      zio.aws.fsx.model.DeleteFileCacheRequest(
        fileCacheId,
        clientRequestToken.map(value => value)
      )
    def fileCacheId: FileCacheId
    def clientRequestToken: Optional[ClientRequestToken]
    def getFileCacheId: ZIO[Any, Nothing, FileCacheId] =
      ZIO.succeed(fileCacheId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileCacheRequest
  ) extends zio.aws.fsx.model.DeleteFileCacheRequest.ReadOnly {
    override val fileCacheId: FileCacheId =
      zio.aws.fsx.model.primitives.FileCacheId(impl.fileCacheId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileCacheRequest
  ): zio.aws.fsx.model.DeleteFileCacheRequest.ReadOnly = new Wrapper(impl)
}
