package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.Flag
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteFileSystemOpenZFSConfiguration(
    skipFinalBackup: Optional[Flag] = Optional.Absent,
    finalBackupTags: Optional[Iterable[zio.aws.fsx.model.Tag]] =
      Optional.Absent,
    options: Optional[
      Iterable[zio.aws.fsx.model.DeleteFileSystemOpenZFSOption]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteFileSystemOpenZFSConfiguration = {
    import DeleteFileSystemOpenZFSConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemOpenZFSConfiguration
      .builder()
      .optionallyWith(
        skipFinalBackup.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.skipFinalBackup)
      .optionallyWith(
        finalBackupTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.finalBackupTags)
      .optionallyWith(
        options.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.optionsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DeleteFileSystemOpenZFSConfiguration.ReadOnly =
    zio.aws.fsx.model.DeleteFileSystemOpenZFSConfiguration.wrap(buildAwsValue())
}
object DeleteFileSystemOpenZFSConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemOpenZFSConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteFileSystemOpenZFSConfiguration =
      zio.aws.fsx.model.DeleteFileSystemOpenZFSConfiguration(
        skipFinalBackup.map(value => value),
        finalBackupTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        options.map(value => value)
      )
    def skipFinalBackup: Optional[Flag]
    def finalBackupTags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def options: Optional[List[zio.aws.fsx.model.DeleteFileSystemOpenZFSOption]]
    def getSkipFinalBackup: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("skipFinalBackup", skipFinalBackup)
    def getFinalBackupTags
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("finalBackupTags", finalBackupTags)
    def getOptions: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.DeleteFileSystemOpenZFSOption
    ]] = AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemOpenZFSConfiguration
  ) extends zio.aws.fsx.model.DeleteFileSystemOpenZFSConfiguration.ReadOnly {
    override val skipFinalBackup: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.skipFinalBackup())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val finalBackupTags
        : Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] = zio.aws.core.internal
      .optionalFromNullable(impl.finalBackupTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
    override val options
        : Optional[List[zio.aws.fsx.model.DeleteFileSystemOpenZFSOption]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.DeleteFileSystemOpenZFSOption.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemOpenZFSConfiguration
  ): zio.aws.fsx.model.DeleteFileSystemOpenZFSConfiguration.ReadOnly =
    new Wrapper(impl)
}
