package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.SnapshotId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteSnapshotResponse(
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    lifecycle: Optional[zio.aws.fsx.model.SnapshotLifecycle] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteSnapshotResponse = {
    import DeleteSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteSnapshotResponse
      .builder()
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteSnapshotResponse.ReadOnly =
    zio.aws.fsx.model.DeleteSnapshotResponse.wrap(buildAwsValue())
}
object DeleteSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteSnapshotResponse =
      zio.aws.fsx.model.DeleteSnapshotResponse(
        snapshotId.map(value => value),
        lifecycle.map(value => value)
      )
    def snapshotId: Optional[SnapshotId]
    def lifecycle: Optional[zio.aws.fsx.model.SnapshotLifecycle]
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getLifecycle: ZIO[Any, AwsError, zio.aws.fsx.model.SnapshotLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteSnapshotResponse
  ) extends zio.aws.fsx.model.DeleteSnapshotResponse.ReadOnly {
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.fsx.model.primitives.SnapshotId(value))
    override val lifecycle: Optional[zio.aws.fsx.model.SnapshotLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.fsx.model.SnapshotLifecycle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteSnapshotResponse
  ): zio.aws.fsx.model.DeleteSnapshotResponse.ReadOnly = new Wrapper(impl)
}
